package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{PaginationToken, SavingsPlanId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlanRatesResponse(
    savingsPlanId: Optional[SavingsPlanId] = Optional.Absent,
    searchResults: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanRate]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse = {
    import DescribeSavingsPlanRatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
      .builder()
      .optionallyWith(
        savingsPlanId.map(value =>
          SavingsPlanId.unwrap(value): java.lang.String
        )
      )(_.savingsPlanId)
      .optionallyWith(
        searchResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlanRatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse =
      zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse(
        savingsPlanId.map(value => value),
        searchResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def savingsPlanId: Optional[SavingsPlanId]
    def searchResults
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanRate.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getSavingsPlanId: ZIO[Any, AwsError, SavingsPlanId] =
      AwsError.unwrapOptionField("savingsPlanId", savingsPlanId)
    def getSearchResults: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanRate.ReadOnly
    ]] = AwsError.unwrapOptionField("searchResults", searchResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly {
    override val savingsPlanId: Optional[SavingsPlanId] = zio.aws.core.internal
      .optionalFromNullable(impl.savingsPlanId())
      .map(value => zio.aws.savingsplans.model.primitives.SavingsPlanId(value))
    override val searchResults
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanRate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanRate.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse
  ): zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly =
    new Wrapper(impl)
}
