package zio.aws.savingsplans.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.savingsplans.model.primitives.{
  SavingsPlanRateOperation,
  SavingsPlanRateUsageType,
  PaginationToken,
  UUID,
  PageSize
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingRatesRequest(
    savingsPlanOfferingIds: Optional[Iterable[UUID]] = Optional.Absent,
    savingsPlanPaymentOptions: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanPaymentOption]
    ] = Optional.Absent,
    savingsPlanTypes: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanType]
    ] = Optional.Absent,
    products: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanProductType]
    ] = Optional.Absent,
    serviceCodes: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanRateServiceCode]
    ] = Optional.Absent,
    usageTypes: Optional[Iterable[SavingsPlanRateUsageType]] = Optional.Absent,
    operations: Optional[Iterable[SavingsPlanRateOperation]] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest = {
    import DescribeSavingsPlansOfferingRatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
      .builder()
      .optionallyWith(
        savingsPlanOfferingIds.map(value =>
          value.map { item =>
            UUID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.savingsPlanOfferingIds)
      .optionallyWith(
        savingsPlanPaymentOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.savingsPlanPaymentOptionsWithStrings)
      .optionallyWith(
        savingsPlanTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.savingsPlanTypesWithStrings)
      .optionallyWith(
        products.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.productsWithStrings)
      .optionallyWith(
        serviceCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.serviceCodesWithStrings)
      .optionallyWith(
        usageTypes.map(value =>
          value.map { item =>
            SavingsPlanRateUsageType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usageTypes)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            SavingsPlanRateOperation.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingRatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest =
      zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest(
        savingsPlanOfferingIds.map(value => value),
        savingsPlanPaymentOptions.map(value => value),
        savingsPlanTypes.map(value => value),
        products.map(value => value),
        serviceCodes.map(value => value),
        usageTypes.map(value => value),
        operations.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def savingsPlanOfferingIds: Optional[List[UUID]]
    def savingsPlanPaymentOptions
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanPaymentOption]]
    def savingsPlanTypes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanType]]
    def products
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanProductType]]
    def serviceCodes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanRateServiceCode]]
    def usageTypes: Optional[List[SavingsPlanRateUsageType]]
    def operations: Optional[List[SavingsPlanRateOperation]]
    def filters: Optional[List[
      zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly
    ]]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PageSize]
    def getSavingsPlanOfferingIds: ZIO[Any, AwsError, List[UUID]] = AwsError
      .unwrapOptionField("savingsPlanOfferingIds", savingsPlanOfferingIds)
    def getSavingsPlanPaymentOptions: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ]] = AwsError.unwrapOptionField(
      "savingsPlanPaymentOptions",
      savingsPlanPaymentOptions
    )
    def getSavingsPlanTypes
        : ZIO[Any, AwsError, List[zio.aws.savingsplans.model.SavingsPlanType]] =
      AwsError.unwrapOptionField("savingsPlanTypes", savingsPlanTypes)
    def getProducts: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanProductType
    ]] = AwsError.unwrapOptionField("products", products)
    def getServiceCodes: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanRateServiceCode
    ]] = AwsError.unwrapOptionField("serviceCodes", serviceCodes)
    def getUsageTypes: ZIO[Any, AwsError, List[SavingsPlanRateUsageType]] =
      AwsError.unwrapOptionField("usageTypes", usageTypes)
    def getOperations: ZIO[Any, AwsError, List[SavingsPlanRateOperation]] =
      AwsError.unwrapOptionField("operations", operations)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest.ReadOnly {
    override val savingsPlanOfferingIds: Optional[List[UUID]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlanOfferingIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.UUID(item)
          }.toList
        )
    override val savingsPlanPaymentOptions
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanPaymentOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlanPaymentOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanPaymentOption.wrap(item)
          }.toList
        )
    override val savingsPlanTypes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlanTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanType.wrap(item)
          }.toList
        )
    override val products
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanProductType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.products())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanProductType.wrap(item)
          }.toList
        )
    override val serviceCodes: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanRateServiceCode]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanRateServiceCode.wrap(item)
        }.toList
      )
    override val usageTypes: Optional[List[SavingsPlanRateUsageType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanRateUsageType(item)
          }.toList
        )
    override val operations: Optional[List[SavingsPlanRateOperation]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanRateOperation(item)
          }.toList
        )
    override val filters: Optional[List[
      zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.savingsplans.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest
  ): zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest.ReadOnly =
    new Wrapper(impl)
}
