package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingRatesResponse(
    searchResults: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanOfferingRate]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse = {
    import DescribeSavingsPlansOfferingRatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
      .builder()
      .optionallyWith(
        searchResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingRatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse =
      zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse(
        searchResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def searchResults: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getSearchResults: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly
    ]] = AwsError.unwrapOptionField("searchResults", searchResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly {
    override val searchResults: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.searchResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanOfferingRate.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse
  ): zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly =
    new Wrapper(impl)
}
