package zio.aws.savingsplans.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.savingsplans.model.primitives.{
  SavingsPlansDuration,
  SavingsPlanUsageType,
  PaginationToken,
  UUID,
  SavingsPlanOperation,
  SavingsPlanServiceCode,
  SavingsPlanDescription,
  PageSize
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingsRequest(
    offeringIds: Optional[Iterable[UUID]] = Optional.Absent,
    paymentOptions: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanPaymentOption]
    ] = Optional.Absent,
    productType: Optional[zio.aws.savingsplans.model.SavingsPlanProductType] =
      Optional.Absent,
    planTypes: Optional[Iterable[zio.aws.savingsplans.model.SavingsPlanType]] =
      Optional.Absent,
    durations: Optional[Iterable[SavingsPlansDuration]] = Optional.Absent,
    currencies: Optional[Iterable[zio.aws.savingsplans.model.CurrencyCode]] =
      Optional.Absent,
    descriptions: Optional[Iterable[SavingsPlanDescription]] = Optional.Absent,
    serviceCodes: Optional[Iterable[SavingsPlanServiceCode]] = Optional.Absent,
    usageTypes: Optional[Iterable[SavingsPlanUsageType]] = Optional.Absent,
    operations: Optional[Iterable[SavingsPlanOperation]] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest = {
    import DescribeSavingsPlansOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
      .builder()
      .optionallyWith(
        offeringIds.map(value =>
          value.map { item =>
            UUID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.offeringIds)
      .optionallyWith(
        paymentOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.paymentOptionsWithStrings)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(
        planTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.planTypesWithStrings)
      .optionallyWith(
        durations.map(value =>
          value.map { item =>
            SavingsPlansDuration.unwrap(item): java.lang.Long
          }.asJavaCollection
        )
      )(_.durations)
      .optionallyWith(
        currencies.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.currenciesWithStrings)
      .optionallyWith(
        descriptions.map(value =>
          value.map { item =>
            SavingsPlanDescription.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.descriptions)
      .optionallyWith(
        serviceCodes.map(value =>
          value.map { item =>
            SavingsPlanServiceCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.serviceCodes)
      .optionallyWith(
        usageTypes.map(value =>
          value.map { item =>
            SavingsPlanUsageType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usageTypes)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            SavingsPlanOperation.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsRequest.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsRequest =
      zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsRequest(
        offeringIds.map(value => value),
        paymentOptions.map(value => value),
        productType.map(value => value),
        planTypes.map(value => value),
        durations.map(value => value),
        currencies.map(value => value),
        descriptions.map(value => value),
        serviceCodes.map(value => value),
        usageTypes.map(value => value),
        operations.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def offeringIds: Optional[List[UUID]]
    def paymentOptions
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanPaymentOption]]
    def productType: Optional[zio.aws.savingsplans.model.SavingsPlanProductType]
    def planTypes: Optional[List[zio.aws.savingsplans.model.SavingsPlanType]]
    def durations: Optional[List[SavingsPlansDuration]]
    def currencies: Optional[List[zio.aws.savingsplans.model.CurrencyCode]]
    def descriptions: Optional[List[SavingsPlanDescription]]
    def serviceCodes: Optional[List[SavingsPlanServiceCode]]
    def usageTypes: Optional[List[SavingsPlanUsageType]]
    def operations: Optional[List[SavingsPlanOperation]]
    def filters: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PageSize]
    def getOfferingIds: ZIO[Any, AwsError, List[UUID]] =
      AwsError.unwrapOptionField("offeringIds", offeringIds)
    def getPaymentOptions: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ]] = AwsError.unwrapOptionField("paymentOptions", paymentOptions)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getPlanTypes
        : ZIO[Any, AwsError, List[zio.aws.savingsplans.model.SavingsPlanType]] =
      AwsError.unwrapOptionField("planTypes", planTypes)
    def getDurations: ZIO[Any, AwsError, List[SavingsPlansDuration]] =
      AwsError.unwrapOptionField("durations", durations)
    def getCurrencies
        : ZIO[Any, AwsError, List[zio.aws.savingsplans.model.CurrencyCode]] =
      AwsError.unwrapOptionField("currencies", currencies)
    def getDescriptions: ZIO[Any, AwsError, List[SavingsPlanDescription]] =
      AwsError.unwrapOptionField("descriptions", descriptions)
    def getServiceCodes: ZIO[Any, AwsError, List[SavingsPlanServiceCode]] =
      AwsError.unwrapOptionField("serviceCodes", serviceCodes)
    def getUsageTypes: ZIO[Any, AwsError, List[SavingsPlanUsageType]] =
      AwsError.unwrapOptionField("usageTypes", usageTypes)
    def getOperations: ZIO[Any, AwsError, List[SavingsPlanOperation]] =
      AwsError.unwrapOptionField("operations", operations)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsRequest.ReadOnly {
    override val offeringIds: Optional[List[UUID]] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.primitives.UUID(item)
        }.toList
      )
    override val paymentOptions
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanPaymentOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanPaymentOption.wrap(item)
          }.toList
        )
    override val productType
        : Optional[zio.aws.savingsplans.model.SavingsPlanProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanProductType.wrap(value)
        )
    override val planTypes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanType.wrap(item)
          }.toList
        )
    override val durations: Optional[List[SavingsPlansDuration]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlansDuration(item)
          }.toList
        )
    override val currencies
        : Optional[List[zio.aws.savingsplans.model.CurrencyCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.CurrencyCode.wrap(item)
          }.toList
        )
    override val descriptions: Optional[List[SavingsPlanDescription]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.descriptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanDescription(item)
          }.toList
        )
    override val serviceCodes: Optional[List[SavingsPlanServiceCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanServiceCode(item)
          }.toList
        )
    override val usageTypes: Optional[List[SavingsPlanUsageType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanUsageType(item)
          }.toList
        )
    override val operations: Optional[List[SavingsPlanOperation]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanOperation(item)
          }.toList
        )
    override val filters: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.savingsplans.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest
  ): zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
