package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansOfferingsResponse(
    searchResults: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanOffering]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse = {
    import DescribeSavingsPlansOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
      .builder()
      .optionallyWith(
        searchResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse =
      zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse(
        searchResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def searchResults: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOffering.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getSearchResults: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanOffering.ReadOnly
    ]] = AwsError.unwrapOptionField("searchResults", searchResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly {
    override val searchResults: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOffering.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.searchResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanOffering.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse
  ): zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
