package zio.aws.savingsplans.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.savingsplans.model.primitives.{
  MaxResults,
  PaginationToken,
  SavingsPlanId,
  SavingsPlanArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansRequest(
    savingsPlanArns: Optional[Iterable[SavingsPlanArn]] = Optional.Absent,
    savingsPlanIds: Optional[Iterable[SavingsPlanId]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    states: Optional[Iterable[zio.aws.savingsplans.model.SavingsPlanState]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.savingsplans.model.SavingsPlanFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest = {
    import DescribeSavingsPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
      .builder()
      .optionallyWith(
        savingsPlanArns.map(value =>
          value.map { item =>
            SavingsPlanArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.savingsPlanArns)
      .optionallyWith(
        savingsPlanIds.map(value =>
          value.map { item =>
            SavingsPlanId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.savingsPlanIds)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlansRequest.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlansRequest.wrap(buildAwsValue())
}
object DescribeSavingsPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.DescribeSavingsPlansRequest =
      zio.aws.savingsplans.model.DescribeSavingsPlansRequest(
        savingsPlanArns.map(value => value),
        savingsPlanIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        states.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def savingsPlanArns: Optional[List[SavingsPlanArn]]
    def savingsPlanIds: Optional[List[SavingsPlanId]]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def states: Optional[List[zio.aws.savingsplans.model.SavingsPlanState]]
    def filters
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanFilter.ReadOnly]]
    def getSavingsPlanArns: ZIO[Any, AwsError, List[SavingsPlanArn]] =
      AwsError.unwrapOptionField("savingsPlanArns", savingsPlanArns)
    def getSavingsPlanIds: ZIO[Any, AwsError, List[SavingsPlanId]] =
      AwsError.unwrapOptionField("savingsPlanIds", savingsPlanIds)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStates: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanState
    ]] = AwsError.unwrapOptionField("states", states)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlansRequest.ReadOnly {
    override val savingsPlanArns: Optional[List[SavingsPlanArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlanArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanArn(item)
          }.toList
        )
    override val savingsPlanIds: Optional[List[SavingsPlanId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlanIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives.SavingsPlanId(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.savingsplans.model.primitives.MaxResults(value))
    override val states
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanState.wrap(item)
          }.toList
        )
    override val filters: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest
  ): zio.aws.savingsplans.model.DescribeSavingsPlansRequest.ReadOnly =
    new Wrapper(impl)
}
