package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlansResponse(
    savingsPlans: Optional[Iterable[zio.aws.savingsplans.model.SavingsPlan]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse = {
    import DescribeSavingsPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
      .builder()
      .optionallyWith(
        savingsPlans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.savingsPlans)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlansResponse
      .wrap(buildAwsValue())
}
object DescribeSavingsPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.DescribeSavingsPlansResponse =
      zio.aws.savingsplans.model.DescribeSavingsPlansResponse(
        savingsPlans.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def savingsPlans
        : Optional[List[zio.aws.savingsplans.model.SavingsPlan.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getSavingsPlans: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlan.ReadOnly
    ]] = AwsError.unwrapOptionField("savingsPlans", savingsPlans)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly {
    override val savingsPlans
        : Optional[List[zio.aws.savingsplans.model.SavingsPlan.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlans())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlan.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse
  ): zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly =
    new Wrapper(impl)
}
