package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.SavingsPlanArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: SavingsPlanArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(SavingsPlanArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.savingsplans.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.ListTagsForResourceRequest =
      zio.aws.savingsplans.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: SavingsPlanArn
    def getResourceArn: ZIO[Any, Nothing, SavingsPlanArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest
  ) extends zio.aws.savingsplans.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: SavingsPlanArn =
      zio.aws.savingsplans.model.primitives.SavingsPlanArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest
  ): zio.aws.savingsplans.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
