package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{
  SavingsPlanDescription,
  SavingsPlansDuration,
  UUID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ParentSavingsPlanOffering(
    offeringId: Optional[UUID] = Optional.Absent,
    paymentOption: Optional[
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ] = Optional.Absent,
    planType: Optional[zio.aws.savingsplans.model.SavingsPlanType] =
      Optional.Absent,
    durationSeconds: Optional[SavingsPlansDuration] = Optional.Absent,
    currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      Optional.Absent,
    planDescription: Optional[SavingsPlanDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering = {
    import ParentSavingsPlanOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
      .builder()
      .optionallyWith(
        offeringId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.offeringId)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(
        durationSeconds.map(value =>
          SavingsPlansDuration.unwrap(value): java.lang.Long
        )
      )(_.durationSeconds)
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(
        planDescription.map(value =>
          SavingsPlanDescription.unwrap(value): java.lang.String
        )
      )(_.planDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly =
    zio.aws.savingsplans.model.ParentSavingsPlanOffering.wrap(buildAwsValue())
}
object ParentSavingsPlanOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.ParentSavingsPlanOffering =
      zio.aws.savingsplans.model.ParentSavingsPlanOffering(
        offeringId.map(value => value),
        paymentOption.map(value => value),
        planType.map(value => value),
        durationSeconds.map(value => value),
        currency.map(value => value),
        planDescription.map(value => value)
      )
    def offeringId: Optional[UUID]
    def paymentOption
        : Optional[zio.aws.savingsplans.model.SavingsPlanPaymentOption]
    def planType: Optional[zio.aws.savingsplans.model.SavingsPlanType]
    def durationSeconds: Optional[SavingsPlansDuration]
    def currency: Optional[zio.aws.savingsplans.model.CurrencyCode]
    def planDescription: Optional[SavingsPlanDescription]
    def getOfferingId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getPlanType
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.SavingsPlanType] =
      AwsError.unwrapOptionField("planType", planType)
    def getDurationSeconds: ZIO[Any, AwsError, SavingsPlansDuration] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getCurrency
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.CurrencyCode] =
      AwsError.unwrapOptionField("currency", currency)
    def getPlanDescription: ZIO[Any, AwsError, SavingsPlanDescription] =
      AwsError.unwrapOptionField("planDescription", planDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
  ) extends zio.aws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly {
    override val offeringId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringId())
      .map(value => zio.aws.savingsplans.model.primitives.UUID(value))
    override val paymentOption
        : Optional[zio.aws.savingsplans.model.SavingsPlanPaymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOption())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanPaymentOption.wrap(value)
        )
    override val planType
        : Optional[zio.aws.savingsplans.model.SavingsPlanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planType())
        .map(value => zio.aws.savingsplans.model.SavingsPlanType.wrap(value))
    override val durationSeconds: Optional[SavingsPlansDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlansDuration(value)
        )
    override val currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.savingsplans.model.CurrencyCode.wrap(value))
    override val planDescription: Optional[SavingsPlanDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planDescription())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.ParentSavingsPlanOffering
  ): zio.aws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly =
    new Wrapper(impl)
}
