package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{
  SavingsPlanArn,
  TagValue,
  Amount,
  SavingsPlanOfferingId,
  Region,
  SavingsPlanId,
  EC2InstanceFamily,
  TermDurationInSeconds,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlan(
    offeringId: Optional[SavingsPlanOfferingId] = Optional.Absent,
    savingsPlanId: Optional[SavingsPlanId] = Optional.Absent,
    savingsPlanArn: Optional[SavingsPlanArn] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    start: Optional[String] = Optional.Absent,
    end: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.savingsplans.model.SavingsPlanState] =
      Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    ec2InstanceFamily: Optional[EC2InstanceFamily] = Optional.Absent,
    savingsPlanType: Optional[zio.aws.savingsplans.model.SavingsPlanType] =
      Optional.Absent,
    paymentOption: Optional[
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ] = Optional.Absent,
    productTypes: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanProductType]
    ] = Optional.Absent,
    currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      Optional.Absent,
    commitment: Optional[Amount] = Optional.Absent,
    upfrontPaymentAmount: Optional[Amount] = Optional.Absent,
    recurringPaymentAmount: Optional[Amount] = Optional.Absent,
    termDurationInSeconds: Optional[TermDurationInSeconds] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlan = {
    import SavingsPlan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlan
      .builder()
      .optionallyWith(
        offeringId.map(value =>
          SavingsPlanOfferingId.unwrap(value): java.lang.String
        )
      )(_.offeringId)
      .optionallyWith(
        savingsPlanId.map(value =>
          SavingsPlanId.unwrap(value): java.lang.String
        )
      )(_.savingsPlanId)
      .optionallyWith(
        savingsPlanArn.map(value =>
          SavingsPlanArn.unwrap(value): java.lang.String
        )
      )(_.savingsPlanArn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(start.map(value => value: java.lang.String))(_.start)
      .optionallyWith(end.map(value => value: java.lang.String))(_.end)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        ec2InstanceFamily.map(value =>
          EC2InstanceFamily.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceFamily)
      .optionallyWith(savingsPlanType.map(value => value.unwrap))(
        _.savingsPlanType
      )
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        productTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.productTypesWithStrings)
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(
        commitment.map(value => Amount.unwrap(value): java.lang.String)
      )(_.commitment)
      .optionallyWith(
        upfrontPaymentAmount.map(value =>
          Amount.unwrap(value): java.lang.String
        )
      )(_.upfrontPaymentAmount)
      .optionallyWith(
        recurringPaymentAmount.map(value =>
          Amount.unwrap(value): java.lang.String
        )
      )(_.recurringPaymentAmount)
      .optionallyWith(
        termDurationInSeconds.map(value =>
          TermDurationInSeconds.unwrap(value): java.lang.Long
        )
      )(_.termDurationInSeconds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.SavingsPlan.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlan.wrap(buildAwsValue())
}
object SavingsPlan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlan =
      zio.aws.savingsplans.model.SavingsPlan(
        offeringId.map(value => value),
        savingsPlanId.map(value => value),
        savingsPlanArn.map(value => value),
        description.map(value => value),
        start.map(value => value),
        end.map(value => value),
        state.map(value => value),
        region.map(value => value),
        ec2InstanceFamily.map(value => value),
        savingsPlanType.map(value => value),
        paymentOption.map(value => value),
        productTypes.map(value => value),
        currency.map(value => value),
        commitment.map(value => value),
        upfrontPaymentAmount.map(value => value),
        recurringPaymentAmount.map(value => value),
        termDurationInSeconds.map(value => value),
        tags.map(value => value)
      )
    def offeringId: Optional[SavingsPlanOfferingId]
    def savingsPlanId: Optional[SavingsPlanId]
    def savingsPlanArn: Optional[SavingsPlanArn]
    def description: Optional[String]
    def start: Optional[String]
    def end: Optional[String]
    def state: Optional[zio.aws.savingsplans.model.SavingsPlanState]
    def region: Optional[Region]
    def ec2InstanceFamily: Optional[EC2InstanceFamily]
    def savingsPlanType: Optional[zio.aws.savingsplans.model.SavingsPlanType]
    def paymentOption
        : Optional[zio.aws.savingsplans.model.SavingsPlanPaymentOption]
    def productTypes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanProductType]]
    def currency: Optional[zio.aws.savingsplans.model.CurrencyCode]
    def commitment: Optional[Amount]
    def upfrontPaymentAmount: Optional[Amount]
    def recurringPaymentAmount: Optional[Amount]
    def termDurationInSeconds: Optional[TermDurationInSeconds]
    def tags: Optional[Map[TagKey, TagValue]]
    def getOfferingId: ZIO[Any, AwsError, SavingsPlanOfferingId] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getSavingsPlanId: ZIO[Any, AwsError, SavingsPlanId] =
      AwsError.unwrapOptionField("savingsPlanId", savingsPlanId)
    def getSavingsPlanArn: ZIO[Any, AwsError, SavingsPlanArn] =
      AwsError.unwrapOptionField("savingsPlanArn", savingsPlanArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStart: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("end", end)
    def getState
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.SavingsPlanState] =
      AwsError.unwrapOptionField("state", state)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getEc2InstanceFamily: ZIO[Any, AwsError, EC2InstanceFamily] =
      AwsError.unwrapOptionField("ec2InstanceFamily", ec2InstanceFamily)
    def getSavingsPlanType
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.SavingsPlanType] =
      AwsError.unwrapOptionField("savingsPlanType", savingsPlanType)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getProductTypes: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanProductType
    ]] = AwsError.unwrapOptionField("productTypes", productTypes)
    def getCurrency
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.CurrencyCode] =
      AwsError.unwrapOptionField("currency", currency)
    def getCommitment: ZIO[Any, AwsError, Amount] =
      AwsError.unwrapOptionField("commitment", commitment)
    def getUpfrontPaymentAmount: ZIO[Any, AwsError, Amount] =
      AwsError.unwrapOptionField("upfrontPaymentAmount", upfrontPaymentAmount)
    def getRecurringPaymentAmount: ZIO[Any, AwsError, Amount] = AwsError
      .unwrapOptionField("recurringPaymentAmount", recurringPaymentAmount)
    def getTermDurationInSeconds: ZIO[Any, AwsError, TermDurationInSeconds] =
      AwsError.unwrapOptionField("termDurationInSeconds", termDurationInSeconds)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlan
  ) extends zio.aws.savingsplans.model.SavingsPlan.ReadOnly {
    override val offeringId: Optional[SavingsPlanOfferingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringId())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanOfferingId(value)
        )
    override val savingsPlanId: Optional[SavingsPlanId] = zio.aws.core.internal
      .optionalFromNullable(impl.savingsPlanId())
      .map(value => zio.aws.savingsplans.model.primitives.SavingsPlanId(value))
    override val savingsPlanArn: Optional[SavingsPlanArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlanArn())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanArn(value)
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val start: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => value: String)
    override val end: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => value: String)
    override val state: Optional[zio.aws.savingsplans.model.SavingsPlanState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.savingsplans.model.SavingsPlanState.wrap(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.savingsplans.model.primitives.Region(value))
    override val ec2InstanceFamily: Optional[EC2InstanceFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceFamily())
        .map(value =>
          zio.aws.savingsplans.model.primitives.EC2InstanceFamily(value)
        )
    override val savingsPlanType
        : Optional[zio.aws.savingsplans.model.SavingsPlanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsPlanType())
        .map(value => zio.aws.savingsplans.model.SavingsPlanType.wrap(value))
    override val paymentOption
        : Optional[zio.aws.savingsplans.model.SavingsPlanPaymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOption())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanPaymentOption.wrap(value)
        )
    override val productTypes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanProductType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanProductType.wrap(item)
          }.toList
        )
    override val currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.savingsplans.model.CurrencyCode.wrap(value))
    override val commitment: Optional[Amount] = zio.aws.core.internal
      .optionalFromNullable(impl.commitment())
      .map(value => zio.aws.savingsplans.model.primitives.Amount(value))
    override val upfrontPaymentAmount: Optional[Amount] = zio.aws.core.internal
      .optionalFromNullable(impl.upfrontPaymentAmount())
      .map(value => zio.aws.savingsplans.model.primitives.Amount(value))
    override val recurringPaymentAmount: Optional[Amount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringPaymentAmount())
        .map(value => zio.aws.savingsplans.model.primitives.Amount(value))
    override val termDurationInSeconds: Optional[TermDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termDurationInSeconds())
        .map(value =>
          zio.aws.savingsplans.model.primitives.TermDurationInSeconds(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.savingsplans.model.primitives.TagKey(
              key
            ) -> zio.aws.savingsplans.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlan
  ): zio.aws.savingsplans.model.SavingsPlan.ReadOnly = new Wrapper(impl)
}
