package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanFilter(
    name: Optional[zio.aws.savingsplans.model.SavingsPlansFilterName] =
      Optional.Absent,
    values: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter = {
    import SavingsPlanFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.SavingsPlanFilter.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanFilter.wrap(buildAwsValue())
}
object SavingsPlanFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlanFilter =
      zio.aws.savingsplans.model
        .SavingsPlanFilter(name.map(value => value), values.map(value => value))
    def name: Optional[zio.aws.savingsplans.model.SavingsPlansFilterName]
    def values: Optional[List[String]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlansFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
  ) extends zio.aws.savingsplans.model.SavingsPlanFilter.ReadOnly {
    override val name
        : Optional[zio.aws.savingsplans.model.SavingsPlansFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlansFilterName.wrap(value)
        )
    override val values: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter
  ): zio.aws.savingsplans.model.SavingsPlanFilter.ReadOnly = new Wrapper(impl)
}
