package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{
  SavingsPlansDuration,
  SavingsPlanUsageType,
  UUID,
  SavingsPlanOperation,
  SavingsPlanServiceCode,
  SavingsPlanDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOffering(
    offeringId: Optional[UUID] = Optional.Absent,
    productTypes: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanProductType]
    ] = Optional.Absent,
    planType: Optional[zio.aws.savingsplans.model.SavingsPlanType] =
      Optional.Absent,
    description: Optional[SavingsPlanDescription] = Optional.Absent,
    paymentOption: Optional[
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ] = Optional.Absent,
    durationSeconds: Optional[SavingsPlansDuration] = Optional.Absent,
    currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      Optional.Absent,
    serviceCode: Optional[SavingsPlanServiceCode] = Optional.Absent,
    usageType: Optional[SavingsPlanUsageType] = Optional.Absent,
    operation: Optional[SavingsPlanOperation] = Optional.Absent,
    properties: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanOfferingProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering = {
    import SavingsPlanOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
      .builder()
      .optionallyWith(
        offeringId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.offeringId)
      .optionallyWith(
        productTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.productTypesWithStrings)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(
        description.map(value =>
          SavingsPlanDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        durationSeconds.map(value =>
          SavingsPlansDuration.unwrap(value): java.lang.Long
        )
      )(_.durationSeconds)
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(
        serviceCode.map(value =>
          SavingsPlanServiceCode.unwrap(value): java.lang.String
        )
      )(_.serviceCode)
      .optionallyWith(
        usageType.map(value =>
          SavingsPlanUsageType.unwrap(value): java.lang.String
        )
      )(_.usageType)
      .optionallyWith(
        operation.map(value =>
          SavingsPlanOperation.unwrap(value): java.lang.String
        )
      )(_.operation)
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.SavingsPlanOffering.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanOffering.wrap(buildAwsValue())
}
object SavingsPlanOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlanOffering =
      zio.aws.savingsplans.model.SavingsPlanOffering(
        offeringId.map(value => value),
        productTypes.map(value => value),
        planType.map(value => value),
        description.map(value => value),
        paymentOption.map(value => value),
        durationSeconds.map(value => value),
        currency.map(value => value),
        serviceCode.map(value => value),
        usageType.map(value => value),
        operation.map(value => value),
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def offeringId: Optional[UUID]
    def productTypes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanProductType]]
    def planType: Optional[zio.aws.savingsplans.model.SavingsPlanType]
    def description: Optional[SavingsPlanDescription]
    def paymentOption
        : Optional[zio.aws.savingsplans.model.SavingsPlanPaymentOption]
    def durationSeconds: Optional[SavingsPlansDuration]
    def currency: Optional[zio.aws.savingsplans.model.CurrencyCode]
    def serviceCode: Optional[SavingsPlanServiceCode]
    def usageType: Optional[SavingsPlanUsageType]
    def operation: Optional[SavingsPlanOperation]
    def properties: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly]
    ]
    def getOfferingId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getProductTypes: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanProductType
    ]] = AwsError.unwrapOptionField("productTypes", productTypes)
    def getPlanType
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.SavingsPlanType] =
      AwsError.unwrapOptionField("planType", planType)
    def getDescription: ZIO[Any, AwsError, SavingsPlanDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanPaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getDurationSeconds: ZIO[Any, AwsError, SavingsPlansDuration] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getCurrency
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.CurrencyCode] =
      AwsError.unwrapOptionField("currency", currency)
    def getServiceCode: ZIO[Any, AwsError, SavingsPlanServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getUsageType: ZIO[Any, AwsError, SavingsPlanUsageType] =
      AwsError.unwrapOptionField("usageType", usageType)
    def getOperation: ZIO[Any, AwsError, SavingsPlanOperation] =
      AwsError.unwrapOptionField("operation", operation)
    def getProperties: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
  ) extends zio.aws.savingsplans.model.SavingsPlanOffering.ReadOnly {
    override val offeringId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringId())
      .map(value => zio.aws.savingsplans.model.primitives.UUID(value))
    override val productTypes
        : Optional[List[zio.aws.savingsplans.model.SavingsPlanProductType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.SavingsPlanProductType.wrap(item)
          }.toList
        )
    override val planType
        : Optional[zio.aws.savingsplans.model.SavingsPlanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planType())
        .map(value => zio.aws.savingsplans.model.SavingsPlanType.wrap(value))
    override val description: Optional[SavingsPlanDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanDescription(value)
        )
    override val paymentOption
        : Optional[zio.aws.savingsplans.model.SavingsPlanPaymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOption())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanPaymentOption.wrap(value)
        )
    override val durationSeconds: Optional[SavingsPlansDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlansDuration(value)
        )
    override val currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.savingsplans.model.CurrencyCode.wrap(value))
    override val serviceCode: Optional[SavingsPlanServiceCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCode())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanServiceCode(value)
        )
    override val usageType: Optional[SavingsPlanUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageType())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanUsageType(value)
        )
    override val operation: Optional[SavingsPlanOperation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanOperation(value)
        )
    override val properties: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanOfferingProperty.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOffering
  ): zio.aws.savingsplans.model.SavingsPlanOffering.ReadOnly = new Wrapper(impl)
}
