package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingFilterElement(
    name: Optional[
      zio.aws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ] = Optional.Absent,
    values: Optional[Iterable[JsonSafeFilterValueString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement = {
    import SavingsPlanOfferingFilterElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            JsonSafeFilterValueString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingFilterElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement =
      zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[
      zio.aws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ]
    def values: Optional[List[JsonSafeFilterValueString]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[JsonSafeFilterValueString]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
  ) extends zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly {
    override val name: Optional[
      zio.aws.savingsplans.model.SavingsPlanOfferingFilterAttribute
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.savingsplans.model.SavingsPlanOfferingFilterAttribute
          .wrap(value)
      )
    override val values: Optional[List[JsonSafeFilterValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives
              .JsonSafeFilterValueString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement
  ): zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement.ReadOnly =
    new Wrapper(impl)
}
