package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{
  SavingsPlanRateOperation,
  SavingsPlanRateUsageType,
  SavingsPlanRatePricePerUnit
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingRate(
    savingsPlanOffering: Optional[
      zio.aws.savingsplans.model.ParentSavingsPlanOffering
    ] = Optional.Absent,
    rate: Optional[SavingsPlanRatePricePerUnit] = Optional.Absent,
    unit: Optional[zio.aws.savingsplans.model.SavingsPlanRateUnit] =
      Optional.Absent,
    productType: Optional[zio.aws.savingsplans.model.SavingsPlanProductType] =
      Optional.Absent,
    serviceCode: Optional[
      zio.aws.savingsplans.model.SavingsPlanRateServiceCode
    ] = Optional.Absent,
    usageType: Optional[SavingsPlanRateUsageType] = Optional.Absent,
    operation: Optional[SavingsPlanRateOperation] = Optional.Absent,
    properties: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate = {
    import SavingsPlanOfferingRate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
      .builder()
      .optionallyWith(savingsPlanOffering.map(value => value.buildAwsValue()))(
        _.savingsPlanOffering
      )
      .optionallyWith(
        rate.map(value =>
          SavingsPlanRatePricePerUnit.unwrap(value): java.lang.String
        )
      )(_.rate)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(serviceCode.map(value => value.unwrap))(_.serviceCode)
      .optionallyWith(
        usageType.map(value =>
          SavingsPlanRateUsageType.unwrap(value): java.lang.String
        )
      )(_.usageType)
      .optionallyWith(
        operation.map(value =>
          SavingsPlanRateOperation.unwrap(value): java.lang.String
        )
      )(_.operation)
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanOfferingRate.wrap(buildAwsValue())
}
object SavingsPlanOfferingRate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlanOfferingRate =
      zio.aws.savingsplans.model.SavingsPlanOfferingRate(
        savingsPlanOffering.map(value => value.asEditable),
        rate.map(value => value),
        unit.map(value => value),
        productType.map(value => value),
        serviceCode.map(value => value),
        usageType.map(value => value),
        operation.map(value => value),
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def savingsPlanOffering: Optional[
      zio.aws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly
    ]
    def rate: Optional[SavingsPlanRatePricePerUnit]
    def unit: Optional[zio.aws.savingsplans.model.SavingsPlanRateUnit]
    def productType: Optional[zio.aws.savingsplans.model.SavingsPlanProductType]
    def serviceCode
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateServiceCode]
    def usageType: Optional[SavingsPlanRateUsageType]
    def operation: Optional[SavingsPlanRateOperation]
    def properties: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly]
    ]
    def getSavingsPlanOffering: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly
    ] = AwsError.unwrapOptionField("savingsPlanOffering", savingsPlanOffering)
    def getRate: ZIO[Any, AwsError, SavingsPlanRatePricePerUnit] =
      AwsError.unwrapOptionField("rate", rate)
    def getUnit
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.SavingsPlanRateUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getServiceCode: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanRateServiceCode
    ] = AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getUsageType: ZIO[Any, AwsError, SavingsPlanRateUsageType] =
      AwsError.unwrapOptionField("usageType", usageType)
    def getOperation: ZIO[Any, AwsError, SavingsPlanRateOperation] =
      AwsError.unwrapOptionField("operation", operation)
    def getProperties: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
  ) extends zio.aws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly {
    override val savingsPlanOffering: Optional[
      zio.aws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.savingsPlanOffering())
      .map(value =>
        zio.aws.savingsplans.model.ParentSavingsPlanOffering.wrap(value)
      )
    override val rate: Optional[SavingsPlanRatePricePerUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rate())
        .map(value =>
          zio.aws.savingsplans.model.primitives
            .SavingsPlanRatePricePerUnit(value)
        )
    override val unit
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanRateUnit.wrap(value)
        )
    override val productType
        : Optional[zio.aws.savingsplans.model.SavingsPlanProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanProductType.wrap(value)
        )
    override val serviceCode
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateServiceCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCode())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanRateServiceCode.wrap(value)
        )
    override val usageType: Optional[SavingsPlanRateUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageType())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanRateUsageType(value)
        )
    override val operation: Optional[SavingsPlanRateOperation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanRateOperation(value)
        )
    override val properties: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
  ): zio.aws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly = new Wrapper(
    impl
  )
}
