package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingRateFilterElement(
    name: Optional[zio.aws.savingsplans.model.SavingsPlanRateFilterAttribute] =
      Optional.Absent,
    values: Optional[Iterable[JsonSafeFilterValueString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement = {
    import SavingsPlanOfferingRateFilterElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            JsonSafeFilterValueString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingRateFilterElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement =
      zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement(
        name.map(value => value),
        values.map(value => value)
      )
    def name
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateFilterAttribute]
    def values: Optional[List[JsonSafeFilterValueString]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanRateFilterAttribute
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[JsonSafeFilterValueString]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
  ) extends zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly {
    override val name
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateFilterAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanRateFilterAttribute.wrap(value)
        )
    override val values: Optional[List[JsonSafeFilterValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.savingsplans.model.primitives
              .JsonSafeFilterValueString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
  ): zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly =
    new Wrapper(impl)
}
