package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingRateProperty(
    name: Optional[JsonSafeFilterValueString] = Optional.Absent,
    value: Optional[JsonSafeFilterValueString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty = {
    import SavingsPlanOfferingRateProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
      .builder()
      .optionallyWith(
        name.map(value =>
          JsonSafeFilterValueString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        value.map(value =>
          JsonSafeFilterValueString.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingRateProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty =
      zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[JsonSafeFilterValueString]
    def value: Optional[JsonSafeFilterValueString]
    def getName: ZIO[Any, AwsError, JsonSafeFilterValueString] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, JsonSafeFilterValueString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
  ) extends zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly {
    override val name: Optional[JsonSafeFilterValueString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString(value)
        )
    override val value: Optional[JsonSafeFilterValueString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
  ): zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly =
    new Wrapper(impl)
}
