package zio.aws.savingsplans.model
import scala.jdk.CollectionConverters.*
sealed trait SavingsPlanPaymentOption {
  def unwrap: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption
}
object SavingsPlanPaymentOption {
  def wrap(
      value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption
  ): zio.aws.savingsplans.model.SavingsPlanPaymentOption = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.ALL_UPFRONT =>
      val r = `All Upfront`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.PARTIAL_UPFRONT =>
      val r = `Partial Upfront`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.NO_UPFRONT =>
      val r = `No Upfront`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.savingsplans.model.SavingsPlanPaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.UNKNOWN_TO_SDK_VERSION
  }
  case object `All Upfront`
      extends zio.aws.savingsplans.model.SavingsPlanPaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.ALL_UPFRONT
  }
  case object `Partial Upfront`
      extends zio.aws.savingsplans.model.SavingsPlanPaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.PARTIAL_UPFRONT
  }
  case object `No Upfront`
      extends zio.aws.savingsplans.model.SavingsPlanPaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption.NO_UPFRONT
  }
}
