package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{
  SavingsPlanRateOperation,
  SavingsPlanRateUsageType,
  Amount
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanRate(
    rate: Optional[Amount] = Optional.Absent,
    currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      Optional.Absent,
    unit: Optional[zio.aws.savingsplans.model.SavingsPlanRateUnit] =
      Optional.Absent,
    productType: Optional[zio.aws.savingsplans.model.SavingsPlanProductType] =
      Optional.Absent,
    serviceCode: Optional[
      zio.aws.savingsplans.model.SavingsPlanRateServiceCode
    ] = Optional.Absent,
    usageType: Optional[SavingsPlanRateUsageType] = Optional.Absent,
    operation: Optional[SavingsPlanRateOperation] = Optional.Absent,
    properties: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanRateProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate = {
    import SavingsPlanRate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate
      .builder()
      .optionallyWith(
        rate.map(value => Amount.unwrap(value): java.lang.String)
      )(_.rate)
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(serviceCode.map(value => value.unwrap))(_.serviceCode)
      .optionallyWith(
        usageType.map(value =>
          SavingsPlanRateUsageType.unwrap(value): java.lang.String
        )
      )(_.usageType)
      .optionallyWith(
        operation.map(value =>
          SavingsPlanRateOperation.unwrap(value): java.lang.String
        )
      )(_.operation)
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.SavingsPlanRate.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanRate.wrap(buildAwsValue())
}
object SavingsPlanRate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlanRate =
      zio.aws.savingsplans.model.SavingsPlanRate(
        rate.map(value => value),
        currency.map(value => value),
        unit.map(value => value),
        productType.map(value => value),
        serviceCode.map(value => value),
        usageType.map(value => value),
        operation.map(value => value),
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rate: Optional[Amount]
    def currency: Optional[zio.aws.savingsplans.model.CurrencyCode]
    def unit: Optional[zio.aws.savingsplans.model.SavingsPlanRateUnit]
    def productType: Optional[zio.aws.savingsplans.model.SavingsPlanProductType]
    def serviceCode
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateServiceCode]
    def usageType: Optional[SavingsPlanRateUsageType]
    def operation: Optional[SavingsPlanRateOperation]
    def properties: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanRateProperty.ReadOnly]
    ]
    def getRate: ZIO[Any, AwsError, Amount] =
      AwsError.unwrapOptionField("rate", rate)
    def getCurrency
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.CurrencyCode] =
      AwsError.unwrapOptionField("currency", currency)
    def getUnit
        : ZIO[Any, AwsError, zio.aws.savingsplans.model.SavingsPlanRateUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getServiceCode: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanRateServiceCode
    ] = AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getUsageType: ZIO[Any, AwsError, SavingsPlanRateUsageType] =
      AwsError.unwrapOptionField("usageType", usageType)
    def getOperation: ZIO[Any, AwsError, SavingsPlanRateOperation] =
      AwsError.unwrapOptionField("operation", operation)
    def getProperties: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanRateProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate
  ) extends zio.aws.savingsplans.model.SavingsPlanRate.ReadOnly {
    override val rate: Optional[Amount] = zio.aws.core.internal
      .optionalFromNullable(impl.rate())
      .map(value => zio.aws.savingsplans.model.primitives.Amount(value))
    override val currency: Optional[zio.aws.savingsplans.model.CurrencyCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.savingsplans.model.CurrencyCode.wrap(value))
    override val unit
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanRateUnit.wrap(value)
        )
    override val productType
        : Optional[zio.aws.savingsplans.model.SavingsPlanProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanProductType.wrap(value)
        )
    override val serviceCode
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateServiceCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCode())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanRateServiceCode.wrap(value)
        )
    override val usageType: Optional[SavingsPlanRateUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageType())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanRateUsageType(value)
        )
    override val operation: Optional[SavingsPlanRateOperation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value =>
          zio.aws.savingsplans.model.primitives.SavingsPlanRateOperation(value)
        )
    override val properties: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanRateProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanRateProperty.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate
  ): zio.aws.savingsplans.model.SavingsPlanRate.ReadOnly = new Wrapper(impl)
}
