package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanRateFilter(
    name: Optional[zio.aws.savingsplans.model.SavingsPlanRateFilterName] =
      Optional.Absent,
    values: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter = {
    import SavingsPlanRateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.SavingsPlanRateFilter.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanRateFilter.wrap(buildAwsValue())
}
object SavingsPlanRateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlanRateFilter =
      zio.aws.savingsplans.model.SavingsPlanRateFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[zio.aws.savingsplans.model.SavingsPlanRateFilterName]
    def values: Optional[List[String]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanRateFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
  ) extends zio.aws.savingsplans.model.SavingsPlanRateFilter.ReadOnly {
    override val name
        : Optional[zio.aws.savingsplans.model.SavingsPlanRateFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanRateFilterName.wrap(value)
        )
    override val values: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateFilter
  ): zio.aws.savingsplans.model.SavingsPlanRateFilter.ReadOnly = new Wrapper(
    impl
  )
}
