package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SavingsPlanRateProperty(
    name: Optional[zio.aws.savingsplans.model.SavingsPlanRatePropertyKey] =
      Optional.Absent,
    value: Optional[JsonSafeFilterValueString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty = {
    import SavingsPlanRateProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          JsonSafeFilterValueString.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.SavingsPlanRateProperty.ReadOnly =
    zio.aws.savingsplans.model.SavingsPlanRateProperty.wrap(buildAwsValue())
}
object SavingsPlanRateProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.SavingsPlanRateProperty =
      zio.aws.savingsplans.model.SavingsPlanRateProperty(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.savingsplans.model.SavingsPlanRatePropertyKey]
    def value: Optional[JsonSafeFilterValueString]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.savingsplans.model.SavingsPlanRatePropertyKey
    ] = AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, JsonSafeFilterValueString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
  ) extends zio.aws.savingsplans.model.SavingsPlanRateProperty.ReadOnly {
    override val name
        : Optional[zio.aws.savingsplans.model.SavingsPlanRatePropertyKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.savingsplans.model.SavingsPlanRatePropertyKey.wrap(value)
        )
    override val value: Optional[JsonSafeFilterValueString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateProperty
  ): zio.aws.savingsplans.model.SavingsPlanRateProperty.ReadOnly = new Wrapper(
    impl
  )
}
