package zio.aws.savingsplans.model
import scala.jdk.CollectionConverters.*
sealed trait SavingsPlanState {
  def unwrap
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState
}
object SavingsPlanState {
  def wrap(
      value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState
  ): zio.aws.savingsplans.model.SavingsPlanState = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_PENDING =>
      val r = `payment-pending`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_FAILED =>
      val r = `payment-failed`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.RETIRED =>
      val r = retired
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED =>
      val r = queued
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED_DELETED =>
      val r = `queued-deleted`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.UNKNOWN_TO_SDK_VERSION
  }
  case object `payment-pending`
      extends zio.aws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_PENDING
  }
  case object `payment-failed`
      extends zio.aws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_FAILED
  }
  case object active extends zio.aws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.ACTIVE
  }
  case object retired extends zio.aws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.RETIRED
  }
  case object queued extends zio.aws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED
  }
  case object `queued-deleted`
      extends zio.aws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED_DELETED
  }
}
