package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{TagValue, TagKey, SavingsPlanArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: SavingsPlanArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
      .builder()
      .resourceArn(SavingsPlanArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.TagResourceRequest.ReadOnly =
    zio.aws.savingsplans.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.TagResourceRequest =
      zio.aws.savingsplans.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: SavingsPlanArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, SavingsPlanArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
  ) extends zio.aws.savingsplans.model.TagResourceRequest.ReadOnly {
    override val resourceArn: SavingsPlanArn =
      zio.aws.savingsplans.model.primitives.SavingsPlanArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.savingsplans.model.primitives
          .TagKey(key) -> zio.aws.savingsplans.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.TagResourceRequest
  ): zio.aws.savingsplans.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
