package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.{TagKey, SavingsPlanArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: SavingsPlanArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
      .builder()
      .resourceArn(SavingsPlanArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.UntagResourceRequest.ReadOnly =
    zio.aws.savingsplans.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.UntagResourceRequest =
      zio.aws.savingsplans.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: SavingsPlanArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, SavingsPlanArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
  ) extends zio.aws.savingsplans.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: SavingsPlanArn =
      zio.aws.savingsplans.model.primitives.SavingsPlanArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.savingsplans.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
  ): zio.aws.savingsplans.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
