package zio.aws.savingsplans
import zio.prelude.Subtype
import zio.aws.savingsplans.model.primitives.{
  JsonSafeFilterValueString,
  SavingsPlanArn,
  SavingsPlansDuration,
  SavingsPlanRateOperation,
  SavingsPlanRateUsageType,
  SavingsPlanUsageType,
  TagValue,
  UUID,
  SavingsPlanOperation,
  SavingsPlanServiceCode,
  SavingsPlanDescription,
  SavingsPlanId,
  TagKey
}
import java.time.Instant
import zio.aws.savingsplans.model.primitives.SavingsPlanUsageType.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Amount extends Subtype[String]
    type Amount = zio.aws.savingsplans.model.primitives.Amount.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.savingsplans.model.primitives.ClientToken.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.savingsplans.model.primitives.DateTime.Type
    object EC2InstanceFamily extends Subtype[String]
    type EC2InstanceFamily =
      zio.aws.savingsplans.model.primitives.EC2InstanceFamily.Type
    object JsonSafeFilterValueString extends Subtype[String]
    type JsonSafeFilterValueString =
      zio.aws.savingsplans.model.primitives.JsonSafeFilterValueString.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.savingsplans.model.primitives.MaxResults.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.savingsplans.model.primitives.PageSize.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.savingsplans.model.primitives.PaginationToken.Type
    object Region extends Subtype[String]
    type Region = zio.aws.savingsplans.model.primitives.Region.Type
    object SavingsPlanArn extends Subtype[String]
    type SavingsPlanArn =
      zio.aws.savingsplans.model.primitives.SavingsPlanArn.Type
    object SavingsPlanDescription extends Subtype[String]
    type SavingsPlanDescription =
      zio.aws.savingsplans.model.primitives.SavingsPlanDescription.Type
    object SavingsPlanId extends Subtype[String]
    type SavingsPlanId =
      zio.aws.savingsplans.model.primitives.SavingsPlanId.Type
    object SavingsPlanOfferingId extends Subtype[String]
    type SavingsPlanOfferingId =
      zio.aws.savingsplans.model.primitives.SavingsPlanOfferingId.Type
    object SavingsPlanOperation extends Subtype[String]
    type SavingsPlanOperation =
      zio.aws.savingsplans.model.primitives.SavingsPlanOperation.Type
    object SavingsPlanRateOperation extends Subtype[String]
    type SavingsPlanRateOperation =
      zio.aws.savingsplans.model.primitives.SavingsPlanRateOperation.Type
    object SavingsPlanRatePricePerUnit extends Subtype[String]
    type SavingsPlanRatePricePerUnit =
      zio.aws.savingsplans.model.primitives.SavingsPlanRatePricePerUnit.Type
    object SavingsPlanRateUsageType extends Subtype[String]
    type SavingsPlanRateUsageType =
      zio.aws.savingsplans.model.primitives.SavingsPlanRateUsageType.Type
    object SavingsPlanServiceCode extends Subtype[String]
    type SavingsPlanServiceCode =
      zio.aws.savingsplans.model.primitives.SavingsPlanServiceCode.Type
    object SavingsPlanUsageType extends Subtype[String]
    type SavingsPlanUsageType =
      zio.aws.savingsplans.model.primitives.SavingsPlanUsageType.Type
    object SavingsPlansDuration extends Subtype[Long]
    type SavingsPlansDuration =
      zio.aws.savingsplans.model.primitives.SavingsPlansDuration.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.savingsplans.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.savingsplans.model.primitives.TagValue.Type
    object TermDurationInSeconds extends Subtype[Long]
    type TermDurationInSeconds =
      zio.aws.savingsplans.model.primitives.TermDurationInSeconds.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.savingsplans.model.primitives.UUID.Type
  }
  type CurrencyList = List[zio.aws.savingsplans.model.CurrencyCode]
  type DurationsList = List[SavingsPlansDuration]
  type FilterValuesList = List[JsonSafeFilterValueString]
  type ListOfStrings = List[String]
  type SavingsPlanArnList = List[SavingsPlanArn]
  type SavingsPlanDescriptionsList = List[SavingsPlanDescription]
  type SavingsPlanFilterList =
    List[zio.aws.savingsplans.model.SavingsPlanFilter]
  type SavingsPlanIdList = List[SavingsPlanId]
  type SavingsPlanList = List[zio.aws.savingsplans.model.SavingsPlan]
  type SavingsPlanOfferingFiltersList =
    List[zio.aws.savingsplans.model.SavingsPlanOfferingFilterElement]
  type SavingsPlanOfferingPropertyList =
    List[zio.aws.savingsplans.model.SavingsPlanOfferingProperty]
  type SavingsPlanOfferingRateFiltersList =
    List[zio.aws.savingsplans.model.SavingsPlanOfferingRateFilterElement]
  type SavingsPlanOfferingRatePropertyList =
    List[zio.aws.savingsplans.model.SavingsPlanOfferingRateProperty]
  type SavingsPlanOfferingRatesList =
    List[zio.aws.savingsplans.model.SavingsPlanOfferingRate]
  type SavingsPlanOfferingsList =
    List[zio.aws.savingsplans.model.SavingsPlanOffering]
  type SavingsPlanOperationList = List[SavingsPlanOperation]
  type SavingsPlanPaymentOptionList =
    List[zio.aws.savingsplans.model.SavingsPlanPaymentOption]
  type SavingsPlanProductTypeList =
    List[zio.aws.savingsplans.model.SavingsPlanProductType]
  type SavingsPlanRateFilterList =
    List[zio.aws.savingsplans.model.SavingsPlanRateFilter]
  type SavingsPlanRateList = List[zio.aws.savingsplans.model.SavingsPlanRate]
  type SavingsPlanRateOperationList = List[SavingsPlanRateOperation]
  type SavingsPlanRatePropertyList =
    List[zio.aws.savingsplans.model.SavingsPlanRateProperty]
  type SavingsPlanRateServiceCodeList =
    List[zio.aws.savingsplans.model.SavingsPlanRateServiceCode]
  type SavingsPlanRateUsageTypeList = List[SavingsPlanRateUsageType]
  type SavingsPlanServiceCodeList = List[SavingsPlanServiceCode]
  type SavingsPlanStateList = List[zio.aws.savingsplans.model.SavingsPlanState]
  type SavingsPlanTypeList = List[zio.aws.savingsplans.model.SavingsPlanType]
  type SavingsPlanUsageTypeList = List[SavingsPlanUsageType]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type UUIDs = List[UUID]
}
