package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.{Subnet, SecurityGroup}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsVpcConfiguration(
    assignPublicIp: Optional[zio.aws.scheduler.model.AssignPublicIp] =
      Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroup]] = Optional.Absent,
    subnets: Iterable[Subnet]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.AwsVpcConfiguration = {
    import AwsVpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.AwsVpcConfiguration
      .builder()
      .optionallyWith(assignPublicIp.map(value => value.unwrap))(
        _.assignPublicIp
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .subnets(subnets.map { item =>
        Subnet.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.AwsVpcConfiguration.ReadOnly =
    zio.aws.scheduler.model.AwsVpcConfiguration.wrap(buildAwsValue())
}
object AwsVpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.AwsVpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.AwsVpcConfiguration =
      zio.aws.scheduler.model.AwsVpcConfiguration(
        assignPublicIp.map(value => value),
        securityGroups.map(value => value),
        subnets
      )
    def assignPublicIp: Optional[zio.aws.scheduler.model.AssignPublicIp]
    def securityGroups: Optional[List[SecurityGroup]]
    def subnets: List[Subnet]
    def getAssignPublicIp
        : ZIO[Any, AwsError, zio.aws.scheduler.model.AssignPublicIp] =
      AwsError.unwrapOptionField("assignPublicIp", assignPublicIp)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroup]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnets: ZIO[Any, Nothing, List[Subnet]] = ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.AwsVpcConfiguration
  ) extends zio.aws.scheduler.model.AwsVpcConfiguration.ReadOnly {
    override val assignPublicIp
        : Optional[zio.aws.scheduler.model.AssignPublicIp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignPublicIp())
        .map(value => zio.aws.scheduler.model.AssignPublicIp.wrap(value))
    override val securityGroups: Optional[List[SecurityGroup]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.scheduler.model.primitives.SecurityGroup(item)
          }.toList
        )
    override val subnets: List[Subnet] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.scheduler.model.primitives.Subnet(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.AwsVpcConfiguration
  ): zio.aws.scheduler.model.AwsVpcConfiguration.ReadOnly = new Wrapper(impl)
}
