package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.{ScheduleGroupName, ClientToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateScheduleGroupRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: ScheduleGroupName,
    tags: Optional[Iterable[zio.aws.scheduler.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest = {
    import CreateScheduleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .name(ScheduleGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.CreateScheduleGroupRequest.ReadOnly =
    zio.aws.scheduler.model.CreateScheduleGroupRequest.wrap(buildAwsValue())
}
object CreateScheduleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.CreateScheduleGroupRequest =
      zio.aws.scheduler.model.CreateScheduleGroupRequest(
        clientToken.map(value => value),
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[ClientToken]
    def name: ScheduleGroupName
    def tags: Optional[List[zio.aws.scheduler.model.Tag.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, ScheduleGroupName] = ZIO.succeed(name)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.scheduler.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest
  ) extends zio.aws.scheduler.model.CreateScheduleGroupRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.scheduler.model.primitives.ClientToken(value))
    override val name: ScheduleGroupName =
      zio.aws.scheduler.model.primitives.ScheduleGroupName(impl.name())
    override val tags: Optional[List[zio.aws.scheduler.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.scheduler.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.CreateScheduleGroupRequest
  ): zio.aws.scheduler.model.CreateScheduleGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
