package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.ScheduleArn
import scala.jdk.CollectionConverters.*
final case class CreateScheduleResponse(scheduleArn: ScheduleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.CreateScheduleResponse = {
    import CreateScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.CreateScheduleResponse
      .builder()
      .scheduleArn(ScheduleArn.unwrap(scheduleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly =
    zio.aws.scheduler.model.CreateScheduleResponse.wrap(buildAwsValue())
}
object CreateScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.CreateScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.CreateScheduleResponse =
      zio.aws.scheduler.model.CreateScheduleResponse(scheduleArn)
    def scheduleArn: ScheduleArn
    def getScheduleArn: ZIO[Any, Nothing, ScheduleArn] =
      ZIO.succeed(scheduleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.CreateScheduleResponse
  ) extends zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly {
    override val scheduleArn: ScheduleArn =
      zio.aws.scheduler.model.primitives.ScheduleArn(impl.scheduleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.CreateScheduleResponse
  ): zio.aws.scheduler.model.CreateScheduleResponse.ReadOnly = new Wrapper(impl)
}
