package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.{ScheduleGroupName, ClientToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteScheduleGroupRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: ScheduleGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest = {
    import DeleteScheduleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .name(ScheduleGroupName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.DeleteScheduleGroupRequest.ReadOnly =
    zio.aws.scheduler.model.DeleteScheduleGroupRequest.wrap(buildAwsValue())
}
object DeleteScheduleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.DeleteScheduleGroupRequest =
      zio.aws.scheduler.model
        .DeleteScheduleGroupRequest(clientToken.map(value => value), name)
    def clientToken: Optional[ClientToken]
    def name: ScheduleGroupName
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, ScheduleGroupName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest
  ) extends zio.aws.scheduler.model.DeleteScheduleGroupRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.scheduler.model.primitives.ClientToken(value))
    override val name: ScheduleGroupName =
      zio.aws.scheduler.model.primitives.ScheduleGroupName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.DeleteScheduleGroupRequest
  ): zio.aws.scheduler.model.DeleteScheduleGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
