package zio.aws.scheduler.model
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  EnableECSManagedTags,
  TaskDefinitionArn,
  TagValue,
  Group,
  ReferenceId,
  TaskCount,
  EnableExecuteCommand,
  PlatformVersion,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EcsParameters(
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.scheduler.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    enableECSManagedTags: Optional[EnableECSManagedTags] = Optional.Absent,
    enableExecuteCommand: Optional[EnableExecuteCommand] = Optional.Absent,
    group: Optional[Group] = Optional.Absent,
    launchType: Optional[zio.aws.scheduler.model.LaunchType] = Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.scheduler.model.NetworkConfiguration
    ] = Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.scheduler.model.PlacementConstraint]
    ] = Optional.Absent,
    placementStrategy: Optional[
      Iterable[zio.aws.scheduler.model.PlacementStrategy]
    ] = Optional.Absent,
    platformVersion: Optional[PlatformVersion] = Optional.Absent,
    propagateTags: Optional[zio.aws.scheduler.model.PropagateTags] =
      Optional.Absent,
    referenceId: Optional[ReferenceId] = Optional.Absent,
    tags: Optional[Iterable[Map[TagKey, TagValue]]] = Optional.Absent,
    taskCount: Optional[TaskCount] = Optional.Absent,
    taskDefinitionArn: TaskDefinitionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.EcsParameters = {
    import EcsParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.EcsParameters
      .builder()
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(
        enableECSManagedTags.map(value =>
          EnableECSManagedTags.unwrap(value): java.lang.Boolean
        )
      )(_.enableECSManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value =>
          EnableExecuteCommand.unwrap(value): java.lang.Boolean
        )
      )(_.enableExecuteCommand)
      .optionallyWith(
        group.map(value => Group.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(
        platformVersion.map(value =>
          PlatformVersion.unwrap(value): java.lang.String
        )
      )(_.platformVersion)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        referenceId.map(value => ReferenceId.unwrap(value): java.lang.String)
      )(_.referenceId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                  value
                ): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(taskCount.map(value => TaskCount.unwrap(value): Integer))(
        _.taskCount
      )
      .taskDefinitionArn(
        TaskDefinitionArn.unwrap(taskDefinitionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.EcsParameters.ReadOnly =
    zio.aws.scheduler.model.EcsParameters.wrap(buildAwsValue())
}
object EcsParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.EcsParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.EcsParameters =
      zio.aws.scheduler.model.EcsParameters(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableECSManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        group.map(value => value),
        launchType.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        propagateTags.map(value => value),
        referenceId.map(value => value),
        tags.map(value => value),
        taskCount.map(value => value),
        taskDefinitionArn
      )
    def capacityProviderStrategy: Optional[
      List[zio.aws.scheduler.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def enableECSManagedTags: Optional[EnableECSManagedTags]
    def enableExecuteCommand: Optional[EnableExecuteCommand]
    def group: Optional[Group]
    def launchType: Optional[zio.aws.scheduler.model.LaunchType]
    def networkConfiguration
        : Optional[zio.aws.scheduler.model.NetworkConfiguration.ReadOnly]
    def placementConstraints
        : Optional[List[zio.aws.scheduler.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Optional[List[zio.aws.scheduler.model.PlacementStrategy.ReadOnly]]
    def platformVersion: Optional[PlatformVersion]
    def propagateTags: Optional[zio.aws.scheduler.model.PropagateTags]
    def referenceId: Optional[ReferenceId]
    def tags: Optional[List[Map[TagKey, TagValue]]]
    def taskCount: Optional[TaskCount]
    def taskDefinitionArn: TaskDefinitionArn
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.scheduler.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getEnableECSManagedTags: ZIO[Any, AwsError, EnableECSManagedTags] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, EnableExecuteCommand] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getGroup: ZIO[Any, AwsError, Group] =
      AwsError.unwrapOptionField("group", group)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.scheduler.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.scheduler.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.scheduler.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.scheduler.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getPlatformVersion: ZIO[Any, AwsError, PlatformVersion] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPropagateTags
        : ZIO[Any, AwsError, zio.aws.scheduler.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getReferenceId: ZIO[Any, AwsError, ReferenceId] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getTags: ZIO[Any, AwsError, List[Map[TagKey, TagValue]]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("taskCount", taskCount)
    def getTaskDefinitionArn: ZIO[Any, Nothing, TaskDefinitionArn] =
      ZIO.succeed(taskDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.EcsParameters
  ) extends zio.aws.scheduler.model.EcsParameters.ReadOnly {
    override val capacityProviderStrategy: Optional[
      List[zio.aws.scheduler.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.scheduler.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val enableECSManagedTags: Optional[EnableECSManagedTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableECSManagedTags())
        .map(value =>
          zio.aws.scheduler.model.primitives.EnableECSManagedTags(value)
        )
    override val enableExecuteCommand: Optional[EnableExecuteCommand] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableExecuteCommand())
        .map(value =>
          zio.aws.scheduler.model.primitives.EnableExecuteCommand(value)
        )
    override val group: Optional[Group] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => zio.aws.scheduler.model.primitives.Group(value))
    override val launchType: Optional[zio.aws.scheduler.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.scheduler.model.LaunchType.wrap(value))
    override val networkConfiguration
        : Optional[zio.aws.scheduler.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.scheduler.model.NetworkConfiguration.wrap(value))
    override val placementConstraints
        : Optional[List[zio.aws.scheduler.model.PlacementConstraint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementConstraints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.scheduler.model.PlacementConstraint.wrap(item)
          }.toList
        )
    override val placementStrategy
        : Optional[List[zio.aws.scheduler.model.PlacementStrategy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStrategy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.scheduler.model.PlacementStrategy.wrap(item)
          }.toList
        )
    override val platformVersion: Optional[PlatformVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformVersion())
        .map(value => zio.aws.scheduler.model.primitives.PlatformVersion(value))
    override val propagateTags
        : Optional[zio.aws.scheduler.model.PropagateTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagateTags())
        .map(value => zio.aws.scheduler.model.PropagateTags.wrap(value))
    override val referenceId: Optional[ReferenceId] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceId())
      .map(value => zio.aws.scheduler.model.primitives.ReferenceId(value))
    override val tags: Optional[List[Map[TagKey, TagValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.scheduler.model.primitives.TagKey(
                  key
                ) -> zio.aws.scheduler.model.primitives.TagValue(value)
              })
              .toMap
          }.toList
        )
    override val taskCount: Optional[TaskCount] = zio.aws.core.internal
      .optionalFromNullable(impl.taskCount())
      .map(value => zio.aws.scheduler.model.primitives.TaskCount(value))
    override val taskDefinitionArn: TaskDefinitionArn =
      zio.aws.scheduler.model.primitives
        .TaskDefinitionArn(impl.taskDefinitionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.EcsParameters
  ): zio.aws.scheduler.model.EcsParameters.ReadOnly = new Wrapper(impl)
}
