package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.{Source, DetailType}
import scala.jdk.CollectionConverters.*
final case class EventBridgeParameters(detailType: DetailType, source: Source) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.EventBridgeParameters = {
    import EventBridgeParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.EventBridgeParameters
      .builder()
      .detailType(DetailType.unwrap(detailType): java.lang.String)
      .source(Source.unwrap(source): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.EventBridgeParameters.ReadOnly =
    zio.aws.scheduler.model.EventBridgeParameters.wrap(buildAwsValue())
}
object EventBridgeParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.EventBridgeParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.EventBridgeParameters =
      zio.aws.scheduler.model.EventBridgeParameters(detailType, source)
    def detailType: DetailType
    def source: Source
    def getDetailType: ZIO[Any, Nothing, DetailType] = ZIO.succeed(detailType)
    def getSource: ZIO[Any, Nothing, Source] = ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.EventBridgeParameters
  ) extends zio.aws.scheduler.model.EventBridgeParameters.ReadOnly {
    override val detailType: DetailType =
      zio.aws.scheduler.model.primitives.DetailType(impl.detailType())
    override val source: Source =
      zio.aws.scheduler.model.primitives.Source(impl.source())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.EventBridgeParameters
  ): zio.aws.scheduler.model.EventBridgeParameters.ReadOnly = new Wrapper(impl)
}
