package zio.aws.scheduler.model
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.MaximumWindowInMinutes
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FlexibleTimeWindow(
    maximumWindowInMinutes: Optional[MaximumWindowInMinutes] = Optional.Absent,
    mode: zio.aws.scheduler.model.FlexibleTimeWindowMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindow = {
    import FlexibleTimeWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindow
      .builder()
      .optionallyWith(
        maximumWindowInMinutes.map(value =>
          MaximumWindowInMinutes.unwrap(value): Integer
        )
      )(_.maximumWindowInMinutes)
      .mode(mode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly =
    zio.aws.scheduler.model.FlexibleTimeWindow.wrap(buildAwsValue())
}
object FlexibleTimeWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.FlexibleTimeWindow =
      zio.aws.scheduler.model
        .FlexibleTimeWindow(maximumWindowInMinutes.map(value => value), mode)
    def maximumWindowInMinutes: Optional[MaximumWindowInMinutes]
    def mode: zio.aws.scheduler.model.FlexibleTimeWindowMode
    def getMaximumWindowInMinutes: ZIO[Any, AwsError, MaximumWindowInMinutes] =
      AwsError.unwrapOptionField(
        "maximumWindowInMinutes",
        maximumWindowInMinutes
      )
    def getMode
        : ZIO[Any, Nothing, zio.aws.scheduler.model.FlexibleTimeWindowMode] =
      ZIO.succeed(mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindow
  ) extends zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly {
    override val maximumWindowInMinutes: Optional[MaximumWindowInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumWindowInMinutes())
        .map(value =>
          zio.aws.scheduler.model.primitives.MaximumWindowInMinutes(value)
        )
    override val mode: zio.aws.scheduler.model.FlexibleTimeWindowMode =
      zio.aws.scheduler.model.FlexibleTimeWindowMode.wrap(impl.mode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindow
  ): zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly = new Wrapper(impl)
}
