package zio.aws.scheduler.model
import scala.jdk.CollectionConverters.*
sealed trait FlexibleTimeWindowMode {
  def unwrap
      : software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode
}
object FlexibleTimeWindowMode {
  def wrap(
      value: software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode
  ): zio.aws.scheduler.model.FlexibleTimeWindowMode = value match {
    case software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode.FLEXIBLE =>
      val r = FLEXIBLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.scheduler.model.FlexibleTimeWindowMode {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode =
      software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.scheduler.model.FlexibleTimeWindowMode {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode =
      software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode.OFF
  }
  case object FLEXIBLE extends zio.aws.scheduler.model.FlexibleTimeWindowMode {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode =
      software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode.FLEXIBLE
  }
}
