package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.{Name, ScheduleGroupName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetScheduleRequest(
    groupName: Optional[ScheduleGroupName] = Optional.Absent,
    name: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.GetScheduleRequest = {
    import GetScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.GetScheduleRequest
      .builder()
      .optionallyWith(
        groupName.map(value =>
          ScheduleGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.GetScheduleRequest.ReadOnly =
    zio.aws.scheduler.model.GetScheduleRequest.wrap(buildAwsValue())
}
object GetScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.GetScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.GetScheduleRequest =
      zio.aws.scheduler.model
        .GetScheduleRequest(groupName.map(value => value), name)
    def groupName: Optional[ScheduleGroupName]
    def name: Name
    def getGroupName: ZIO[Any, AwsError, ScheduleGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.GetScheduleRequest
  ) extends zio.aws.scheduler.model.GetScheduleRequest.ReadOnly {
    override val groupName: Optional[ScheduleGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupName(value))
    override val name: Name =
      zio.aws.scheduler.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.GetScheduleRequest
  ): zio.aws.scheduler.model.GetScheduleRequest.ReadOnly = new Wrapper(impl)
}
