package zio.aws.scheduler.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  EndDate,
  LastModificationDate,
  ScheduleGroupName,
  StartDate,
  ScheduleExpression,
  Description,
  ScheduleExpressionTimezone,
  ScheduleArn,
  KmsKeyArn,
  Name,
  CreationDate
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetScheduleResponse(
    arn: Optional[ScheduleArn] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    endDate: Optional[EndDate] = Optional.Absent,
    flexibleTimeWindow: Optional[zio.aws.scheduler.model.FlexibleTimeWindow] =
      Optional.Absent,
    groupName: Optional[ScheduleGroupName] = Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    lastModificationDate: Optional[LastModificationDate] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    scheduleExpression: Optional[ScheduleExpression] = Optional.Absent,
    scheduleExpressionTimezone: Optional[ScheduleExpressionTimezone] =
      Optional.Absent,
    startDate: Optional[StartDate] = Optional.Absent,
    state: Optional[zio.aws.scheduler.model.ScheduleState] = Optional.Absent,
    target: Optional[zio.aws.scheduler.model.Target] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.GetScheduleResponse = {
    import GetScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.GetScheduleResponse
      .builder()
      .optionallyWith(
        arn.map(value => ScheduleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(endDate.map(value => EndDate.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(flexibleTimeWindow.map(value => value.buildAwsValue()))(
        _.flexibleTimeWindow
      )
      .optionallyWith(
        groupName.map(value =>
          ScheduleGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        lastModificationDate.map(value =>
          LastModificationDate.unwrap(value): Instant
        )
      )(_.lastModificationDate)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        scheduleExpressionTimezone.map(value =>
          ScheduleExpressionTimezone.unwrap(value): java.lang.String
        )
      )(_.scheduleExpressionTimezone)
      .optionallyWith(startDate.map(value => StartDate.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.GetScheduleResponse.ReadOnly =
    zio.aws.scheduler.model.GetScheduleResponse.wrap(buildAwsValue())
}
object GetScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.GetScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.GetScheduleResponse =
      zio.aws.scheduler.model.GetScheduleResponse(
        arn.map(value => value),
        creationDate.map(value => value),
        description.map(value => value),
        endDate.map(value => value),
        flexibleTimeWindow.map(value => value.asEditable),
        groupName.map(value => value),
        kmsKeyArn.map(value => value),
        lastModificationDate.map(value => value),
        name.map(value => value),
        scheduleExpression.map(value => value),
        scheduleExpressionTimezone.map(value => value),
        startDate.map(value => value),
        state.map(value => value),
        target.map(value => value.asEditable)
      )
    def arn: Optional[ScheduleArn]
    def creationDate: Optional[CreationDate]
    def description: Optional[Description]
    def endDate: Optional[EndDate]
    def flexibleTimeWindow
        : Optional[zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly]
    def groupName: Optional[ScheduleGroupName]
    def kmsKeyArn: Optional[KmsKeyArn]
    def lastModificationDate: Optional[LastModificationDate]
    def name: Optional[Name]
    def scheduleExpression: Optional[ScheduleExpression]
    def scheduleExpressionTimezone: Optional[ScheduleExpressionTimezone]
    def startDate: Optional[StartDate]
    def state: Optional[zio.aws.scheduler.model.ScheduleState]
    def target: Optional[zio.aws.scheduler.model.Target.ReadOnly]
    def getArn: ZIO[Any, AwsError, ScheduleArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndDate: ZIO[Any, AwsError, EndDate] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getFlexibleTimeWindow: ZIO[
      Any,
      AwsError,
      zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly
    ] = AwsError.unwrapOptionField("flexibleTimeWindow", flexibleTimeWindow)
    def getGroupName: ZIO[Any, AwsError, ScheduleGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getLastModificationDate: ZIO[Any, AwsError, LastModificationDate] =
      AwsError.unwrapOptionField("lastModificationDate", lastModificationDate)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getScheduleExpressionTimezone
        : ZIO[Any, AwsError, ScheduleExpressionTimezone] =
      AwsError.unwrapOptionField(
        "scheduleExpressionTimezone",
        scheduleExpressionTimezone
      )
    def getStartDate: ZIO[Any, AwsError, StartDate] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getState: ZIO[Any, AwsError, zio.aws.scheduler.model.ScheduleState] =
      AwsError.unwrapOptionField("state", state)
    def getTarget: ZIO[Any, AwsError, zio.aws.scheduler.model.Target.ReadOnly] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.GetScheduleResponse
  ) extends zio.aws.scheduler.model.GetScheduleResponse.ReadOnly {
    override val arn: Optional[ScheduleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleArn(value))
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.scheduler.model.primitives.CreationDate(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.scheduler.model.primitives.Description(value))
    override val endDate: Optional[EndDate] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.scheduler.model.primitives.EndDate(value))
    override val flexibleTimeWindow
        : Optional[zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flexibleTimeWindow())
        .map(value => zio.aws.scheduler.model.FlexibleTimeWindow.wrap(value))
    override val groupName: Optional[ScheduleGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupName(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.scheduler.model.primitives.KmsKeyArn(value))
    override val lastModificationDate: Optional[LastModificationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationDate())
        .map(value =>
          zio.aws.scheduler.model.primitives.LastModificationDate(value)
        )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.scheduler.model.primitives.Name(value))
    override val scheduleExpression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value =>
          zio.aws.scheduler.model.primitives.ScheduleExpression(value)
        )
    override val scheduleExpressionTimezone
        : Optional[ScheduleExpressionTimezone] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleExpressionTimezone())
      .map(value =>
        zio.aws.scheduler.model.primitives.ScheduleExpressionTimezone(value)
      )
    override val startDate: Optional[StartDate] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.scheduler.model.primitives.StartDate(value))
    override val state: Optional[zio.aws.scheduler.model.ScheduleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.scheduler.model.ScheduleState.wrap(value))
    override val target: Optional[zio.aws.scheduler.model.Target.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value => zio.aws.scheduler.model.Target.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.GetScheduleResponse
  ): zio.aws.scheduler.model.GetScheduleResponse.ReadOnly = new Wrapper(impl)
}
