package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.TargetPartitionKey
import scala.jdk.CollectionConverters.*
final case class KinesisParameters(partitionKey: TargetPartitionKey) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.KinesisParameters = {
    import KinesisParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.KinesisParameters
      .builder()
      .partitionKey(TargetPartitionKey.unwrap(partitionKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.KinesisParameters.ReadOnly =
    zio.aws.scheduler.model.KinesisParameters.wrap(buildAwsValue())
}
object KinesisParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.KinesisParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.KinesisParameters =
      zio.aws.scheduler.model.KinesisParameters(partitionKey)
    def partitionKey: TargetPartitionKey
    def getPartitionKey: ZIO[Any, Nothing, TargetPartitionKey] =
      ZIO.succeed(partitionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.KinesisParameters
  ) extends zio.aws.scheduler.model.KinesisParameters.ReadOnly {
    override val partitionKey: TargetPartitionKey =
      zio.aws.scheduler.model.primitives.TargetPartitionKey(impl.partitionKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.KinesisParameters
  ): zio.aws.scheduler.model.KinesisParameters.ReadOnly = new Wrapper(impl)
}
