package zio.aws.scheduler.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchType {
  def unwrap: software.amazon.awssdk.services.scheduler.model.LaunchType
}
object LaunchType {
  def wrap(
      value: software.amazon.awssdk.services.scheduler.model.LaunchType
  ): zio.aws.scheduler.model.LaunchType = value match {
    case software.amazon.awssdk.services.scheduler.model.LaunchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.scheduler.model.LaunchType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.scheduler.model.LaunchType.FARGATE =>
      val r = FARGATE
      r
    case software.amazon.awssdk.services.scheduler.model.LaunchType.EXTERNAL =>
      val r = EXTERNAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.scheduler.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.LaunchType =
      software.amazon.awssdk.services.scheduler.model.LaunchType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.scheduler.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.LaunchType =
      software.amazon.awssdk.services.scheduler.model.LaunchType.EC2
  }
  case object FARGATE extends zio.aws.scheduler.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.LaunchType =
      software.amazon.awssdk.services.scheduler.model.LaunchType.FARGATE
  }
  case object EXTERNAL extends zio.aws.scheduler.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.LaunchType =
      software.amazon.awssdk.services.scheduler.model.LaunchType.EXTERNAL
  }
}
