package zio.aws.scheduler.model
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  NextToken,
  ScheduleGroupNamePrefix,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListScheduleGroupsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    namePrefix: Optional[ScheduleGroupNamePrefix] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest = {
    import ListScheduleGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namePrefix.map(value =>
          ScheduleGroupNamePrefix.unwrap(value): java.lang.String
        )
      )(_.namePrefix)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ListScheduleGroupsRequest.ReadOnly =
    zio.aws.scheduler.model.ListScheduleGroupsRequest.wrap(buildAwsValue())
}
object ListScheduleGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ListScheduleGroupsRequest =
      zio.aws.scheduler.model.ListScheduleGroupsRequest(
        maxResults.map(value => value),
        namePrefix.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def namePrefix: Optional[ScheduleGroupNamePrefix]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamePrefix: ZIO[Any, AwsError, ScheduleGroupNamePrefix] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest
  ) extends zio.aws.scheduler.model.ListScheduleGroupsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.scheduler.model.primitives.MaxResults(value))
    override val namePrefix: Optional[ScheduleGroupNamePrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namePrefix())
        .map(value =>
          zio.aws.scheduler.model.primitives.ScheduleGroupNamePrefix(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.scheduler.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest
  ): zio.aws.scheduler.model.ListScheduleGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
