package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListScheduleGroupsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    scheduleGroups: Iterable[zio.aws.scheduler.model.ScheduleGroupSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse = {
    import ListScheduleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .scheduleGroups(scheduleGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly =
    zio.aws.scheduler.model.ListScheduleGroupsResponse.wrap(buildAwsValue())
}
object ListScheduleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ListScheduleGroupsResponse =
      zio.aws.scheduler.model.ListScheduleGroupsResponse(
        nextToken.map(value => value),
        scheduleGroups.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def scheduleGroups
        : List[zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScheduleGroups: ZIO[Any, Nothing, List[
      zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly
    ]] = ZIO.succeed(scheduleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse
  ) extends zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.scheduler.model.primitives.NextToken(value))
    override val scheduleGroups
        : List[zio.aws.scheduler.model.ScheduleGroupSummary.ReadOnly] = impl
      .scheduleGroups()
      .asScala
      .map { item =>
        zio.aws.scheduler.model.ScheduleGroupSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse
  ): zio.aws.scheduler.model.ListScheduleGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
