package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.PlacementConstraintExpression
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PlacementConstraint(
    expression: Optional[PlacementConstraintExpression] = Optional.Absent,
    `type`: Optional[zio.aws.scheduler.model.PlacementConstraintType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.PlacementConstraint = {
    import PlacementConstraint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.PlacementConstraint
      .builder()
      .optionallyWith(
        expression.map(value =>
          PlacementConstraintExpression.unwrap(value): java.lang.String
        )
      )(_.expression)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.PlacementConstraint.ReadOnly =
    zio.aws.scheduler.model.PlacementConstraint.wrap(buildAwsValue())
}
object PlacementConstraint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.PlacementConstraint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.PlacementConstraint =
      zio.aws.scheduler.model.PlacementConstraint(
        expression.map(value => value),
        `type`.map(value => value)
      )
    def expression: Optional[PlacementConstraintExpression]
    def `type`: Optional[zio.aws.scheduler.model.PlacementConstraintType]
    def getExpression: ZIO[Any, AwsError, PlacementConstraintExpression] =
      AwsError.unwrapOptionField("expression", expression)
    def getType
        : ZIO[Any, AwsError, zio.aws.scheduler.model.PlacementConstraintType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.PlacementConstraint
  ) extends zio.aws.scheduler.model.PlacementConstraint.ReadOnly {
    override val expression: Optional[PlacementConstraintExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expression())
        .map(value =>
          zio.aws.scheduler.model.primitives
            .PlacementConstraintExpression(value)
        )
    override val `type`
        : Optional[zio.aws.scheduler.model.PlacementConstraintType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.scheduler.model.PlacementConstraintType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.PlacementConstraint
  ): zio.aws.scheduler.model.PlacementConstraint.ReadOnly = new Wrapper(impl)
}
