package zio.aws.scheduler.model
import scala.jdk.CollectionConverters.*
sealed trait PlacementConstraintType {
  def unwrap
      : software.amazon.awssdk.services.scheduler.model.PlacementConstraintType
}
object PlacementConstraintType {
  def wrap(
      value: software.amazon.awssdk.services.scheduler.model.PlacementConstraintType
  ): zio.aws.scheduler.model.PlacementConstraintType = value match {
    case software.amazon.awssdk.services.scheduler.model.PlacementConstraintType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.scheduler.model.PlacementConstraintType.DISTINCT_INSTANCE =>
      val r = distinctInstance
      r
    case software.amazon.awssdk.services.scheduler.model.PlacementConstraintType.MEMBER_OF =>
      val r = memberOf
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.scheduler.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.PlacementConstraintType =
      software.amazon.awssdk.services.scheduler.model.PlacementConstraintType.UNKNOWN_TO_SDK_VERSION
  }
  case object distinctInstance
      extends zio.aws.scheduler.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.PlacementConstraintType =
      software.amazon.awssdk.services.scheduler.model.PlacementConstraintType.DISTINCT_INSTANCE
  }
  case object memberOf extends zio.aws.scheduler.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.PlacementConstraintType =
      software.amazon.awssdk.services.scheduler.model.PlacementConstraintType.MEMBER_OF
  }
}
