package zio.aws.scheduler.model
import scala.jdk.CollectionConverters.*
sealed trait PlacementStrategyType {
  def unwrap
      : software.amazon.awssdk.services.scheduler.model.PlacementStrategyType
}
object PlacementStrategyType {
  def wrap(
      value: software.amazon.awssdk.services.scheduler.model.PlacementStrategyType
  ): zio.aws.scheduler.model.PlacementStrategyType = value match {
    case software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.RANDOM =>
      val r = random
      r
    case software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.SPREAD =>
      val r = spread
      r
    case software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.BINPACK =>
      val r = binpack
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.scheduler.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.PlacementStrategyType =
      software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.UNKNOWN_TO_SDK_VERSION
  }
  case object random extends zio.aws.scheduler.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.PlacementStrategyType =
      software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.RANDOM
  }
  case object spread extends zio.aws.scheduler.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.PlacementStrategyType =
      software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.SPREAD
  }
  case object binpack extends zio.aws.scheduler.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.PlacementStrategyType =
      software.amazon.awssdk.services.scheduler.model.PlacementStrategyType.BINPACK
  }
}
