package zio.aws.scheduler.model
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  MaximumRetryAttempts,
  MaximumEventAgeInSeconds
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RetryPolicy(
    maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds] =
      Optional.Absent,
    maximumRetryAttempts: Optional[MaximumRetryAttempts] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.RetryPolicy = {
    import RetryPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.RetryPolicy
      .builder()
      .optionallyWith(
        maximumEventAgeInSeconds.map(value =>
          MaximumEventAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumEventAgeInSeconds)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttempts.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.RetryPolicy.ReadOnly =
    zio.aws.scheduler.model.RetryPolicy.wrap(buildAwsValue())
}
object RetryPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.RetryPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.RetryPolicy =
      zio.aws.scheduler.model.RetryPolicy(
        maximumEventAgeInSeconds.map(value => value),
        maximumRetryAttempts.map(value => value)
      )
    def maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds]
    def maximumRetryAttempts: Optional[MaximumRetryAttempts]
    def getMaximumEventAgeInSeconds
        : ZIO[Any, AwsError, MaximumEventAgeInSeconds] = AwsError
      .unwrapOptionField("maximumEventAgeInSeconds", maximumEventAgeInSeconds)
    def getMaximumRetryAttempts: ZIO[Any, AwsError, MaximumRetryAttempts] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.RetryPolicy
  ) extends zio.aws.scheduler.model.RetryPolicy.ReadOnly {
    override val maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumEventAgeInSeconds())
        .map(value =>
          zio.aws.scheduler.model.primitives.MaximumEventAgeInSeconds(value)
        )
    override val maximumRetryAttempts: Optional[MaximumRetryAttempts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumRetryAttempts())
        .map(value =>
          zio.aws.scheduler.model.primitives.MaximumRetryAttempts(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.RetryPolicy
  ): zio.aws.scheduler.model.RetryPolicy.ReadOnly = new Wrapper(impl)
}
