package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SageMakerPipelineParameters(
    pipelineParameterList: Optional[
      Iterable[zio.aws.scheduler.model.SageMakerPipelineParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameters = {
    import SageMakerPipelineParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameters
      .builder()
      .optionallyWith(
        pipelineParameterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineParameterList)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.SageMakerPipelineParameters.ReadOnly =
    zio.aws.scheduler.model.SageMakerPipelineParameters.wrap(buildAwsValue())
}
object SageMakerPipelineParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.SageMakerPipelineParameters =
      zio.aws.scheduler.model.SageMakerPipelineParameters(
        pipelineParameterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineParameterList: Optional[
      List[zio.aws.scheduler.model.SageMakerPipelineParameter.ReadOnly]
    ]
    def getPipelineParameterList: ZIO[Any, AwsError, List[
      zio.aws.scheduler.model.SageMakerPipelineParameter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("pipelineParameterList", pipelineParameterList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameters
  ) extends zio.aws.scheduler.model.SageMakerPipelineParameters.ReadOnly {
    override val pipelineParameterList: Optional[
      List[zio.aws.scheduler.model.SageMakerPipelineParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineParameterList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.scheduler.model.SageMakerPipelineParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.SageMakerPipelineParameters
  ): zio.aws.scheduler.model.SageMakerPipelineParameters.ReadOnly = new Wrapper(
    impl
  )
}
