package zio.aws.scheduler.model
import scala.jdk.CollectionConverters.*
sealed trait ScheduleGroupState {
  def unwrap: software.amazon.awssdk.services.scheduler.model.ScheduleGroupState
}
object ScheduleGroupState {
  def wrap(
      value: software.amazon.awssdk.services.scheduler.model.ScheduleGroupState
  ): zio.aws.scheduler.model.ScheduleGroupState = value match {
    case software.amazon.awssdk.services.scheduler.model.ScheduleGroupState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.scheduler.model.ScheduleGroupState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.scheduler.model.ScheduleGroupState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.scheduler.model.ScheduleGroupState {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ScheduleGroupState =
      software.amazon.awssdk.services.scheduler.model.ScheduleGroupState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.scheduler.model.ScheduleGroupState {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ScheduleGroupState =
      software.amazon.awssdk.services.scheduler.model.ScheduleGroupState.ACTIVE
  }
  case object DELETING extends zio.aws.scheduler.model.ScheduleGroupState {
    override def unwrap
        : software.amazon.awssdk.services.scheduler.model.ScheduleGroupState =
      software.amazon.awssdk.services.scheduler.model.ScheduleGroupState.DELETING
  }
}
