package zio.aws.scheduler.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  LastModificationDate,
  ScheduleGroupName,
  ScheduleArn,
  Name,
  CreationDate
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ScheduleSummary(
    arn: Optional[ScheduleArn] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    groupName: Optional[ScheduleGroupName] = Optional.Absent,
    lastModificationDate: Optional[LastModificationDate] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    state: Optional[zio.aws.scheduler.model.ScheduleState] = Optional.Absent,
    target: Optional[zio.aws.scheduler.model.TargetSummary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.ScheduleSummary = {
    import ScheduleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.ScheduleSummary
      .builder()
      .optionallyWith(
        arn.map(value => ScheduleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        groupName.map(value =>
          ScheduleGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        lastModificationDate.map(value =>
          LastModificationDate.unwrap(value): Instant
        )
      )(_.lastModificationDate)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.ScheduleSummary.ReadOnly =
    zio.aws.scheduler.model.ScheduleSummary.wrap(buildAwsValue())
}
object ScheduleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.ScheduleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.ScheduleSummary =
      zio.aws.scheduler.model.ScheduleSummary(
        arn.map(value => value),
        creationDate.map(value => value),
        groupName.map(value => value),
        lastModificationDate.map(value => value),
        name.map(value => value),
        state.map(value => value),
        target.map(value => value.asEditable)
      )
    def arn: Optional[ScheduleArn]
    def creationDate: Optional[CreationDate]
    def groupName: Optional[ScheduleGroupName]
    def lastModificationDate: Optional[LastModificationDate]
    def name: Optional[Name]
    def state: Optional[zio.aws.scheduler.model.ScheduleState]
    def target: Optional[zio.aws.scheduler.model.TargetSummary.ReadOnly]
    def getArn: ZIO[Any, AwsError, ScheduleArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getGroupName: ZIO[Any, AwsError, ScheduleGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getLastModificationDate: ZIO[Any, AwsError, LastModificationDate] =
      AwsError.unwrapOptionField("lastModificationDate", lastModificationDate)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.scheduler.model.ScheduleState] =
      AwsError.unwrapOptionField("state", state)
    def getTarget
        : ZIO[Any, AwsError, zio.aws.scheduler.model.TargetSummary.ReadOnly] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.ScheduleSummary
  ) extends zio.aws.scheduler.model.ScheduleSummary.ReadOnly {
    override val arn: Optional[ScheduleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleArn(value))
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.scheduler.model.primitives.CreationDate(value))
    override val groupName: Optional[ScheduleGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupName(value))
    override val lastModificationDate: Optional[LastModificationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationDate())
        .map(value =>
          zio.aws.scheduler.model.primitives.LastModificationDate(value)
        )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.scheduler.model.primitives.Name(value))
    override val state: Optional[zio.aws.scheduler.model.ScheduleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.scheduler.model.ScheduleState.wrap(value))
    override val target
        : Optional[zio.aws.scheduler.model.TargetSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value => zio.aws.scheduler.model.TargetSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.ScheduleSummary
  ): zio.aws.scheduler.model.ScheduleSummary.ReadOnly = new Wrapper(impl)
}
