package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.TagResourceArn
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: TagResourceArn,
    tags: Iterable[zio.aws.scheduler.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.TagResourceRequest
      .builder()
      .resourceArn(TagResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.TagResourceRequest.ReadOnly =
    zio.aws.scheduler.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.TagResourceRequest =
      zio.aws.scheduler.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: TagResourceArn
    def tags: List[zio.aws.scheduler.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, TagResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.scheduler.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.TagResourceRequest
  ) extends zio.aws.scheduler.model.TagResourceRequest.ReadOnly {
    override val resourceArn: TagResourceArn =
      zio.aws.scheduler.model.primitives.TagResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.scheduler.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.scheduler.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.TagResourceRequest
  ): zio.aws.scheduler.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
