package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.scheduler.model.primitives.{RoleArn, TargetInput, TargetArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Target(
    arn: TargetArn,
    deadLetterConfig: Optional[zio.aws.scheduler.model.DeadLetterConfig] =
      Optional.Absent,
    ecsParameters: Optional[zio.aws.scheduler.model.EcsParameters] =
      Optional.Absent,
    eventBridgeParameters: Optional[
      zio.aws.scheduler.model.EventBridgeParameters
    ] = Optional.Absent,
    input: Optional[TargetInput] = Optional.Absent,
    kinesisParameters: Optional[zio.aws.scheduler.model.KinesisParameters] =
      Optional.Absent,
    retryPolicy: Optional[zio.aws.scheduler.model.RetryPolicy] =
      Optional.Absent,
    roleArn: RoleArn,
    sageMakerPipelineParameters: Optional[
      zio.aws.scheduler.model.SageMakerPipelineParameters
    ] = Optional.Absent,
    sqsParameters: Optional[zio.aws.scheduler.model.SqsParameters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.Target
      .builder()
      .arn(TargetArn.unwrap(arn): java.lang.String)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(ecsParameters.map(value => value.buildAwsValue()))(
        _.ecsParameters
      )
      .optionallyWith(
        eventBridgeParameters.map(value => value.buildAwsValue())
      )(_.eventBridgeParameters)
      .optionallyWith(
        input.map(value => TargetInput.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(kinesisParameters.map(value => value.buildAwsValue()))(
        _.kinesisParameters
      )
      .optionallyWith(retryPolicy.map(value => value.buildAwsValue()))(
        _.retryPolicy
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        sageMakerPipelineParameters.map(value => value.buildAwsValue())
      )(_.sageMakerPipelineParameters)
      .optionallyWith(sqsParameters.map(value => value.buildAwsValue()))(
        _.sqsParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.Target.ReadOnly =
    zio.aws.scheduler.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.scheduler.model.Target] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.Target =
      zio.aws.scheduler.model.Target(
        arn,
        deadLetterConfig.map(value => value.asEditable),
        ecsParameters.map(value => value.asEditable),
        eventBridgeParameters.map(value => value.asEditable),
        input.map(value => value),
        kinesisParameters.map(value => value.asEditable),
        retryPolicy.map(value => value.asEditable),
        roleArn,
        sageMakerPipelineParameters.map(value => value.asEditable),
        sqsParameters.map(value => value.asEditable)
      )
    def arn: TargetArn
    def deadLetterConfig
        : Optional[zio.aws.scheduler.model.DeadLetterConfig.ReadOnly]
    def ecsParameters: Optional[zio.aws.scheduler.model.EcsParameters.ReadOnly]
    def eventBridgeParameters
        : Optional[zio.aws.scheduler.model.EventBridgeParameters.ReadOnly]
    def input: Optional[TargetInput]
    def kinesisParameters
        : Optional[zio.aws.scheduler.model.KinesisParameters.ReadOnly]
    def retryPolicy: Optional[zio.aws.scheduler.model.RetryPolicy.ReadOnly]
    def roleArn: RoleArn
    def sageMakerPipelineParameters
        : Optional[zio.aws.scheduler.model.SageMakerPipelineParameters.ReadOnly]
    def sqsParameters: Optional[zio.aws.scheduler.model.SqsParameters.ReadOnly]
    def getArn: ZIO[Any, Nothing, TargetArn] = ZIO.succeed(arn)
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.scheduler.model.DeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getEcsParameters
        : ZIO[Any, AwsError, zio.aws.scheduler.model.EcsParameters.ReadOnly] =
      AwsError.unwrapOptionField("ecsParameters", ecsParameters)
    def getEventBridgeParameters: ZIO[
      Any,
      AwsError,
      zio.aws.scheduler.model.EventBridgeParameters.ReadOnly
    ] =
      AwsError.unwrapOptionField("eventBridgeParameters", eventBridgeParameters)
    def getInput: ZIO[Any, AwsError, TargetInput] =
      AwsError.unwrapOptionField("input", input)
    def getKinesisParameters: ZIO[
      Any,
      AwsError,
      zio.aws.scheduler.model.KinesisParameters.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisParameters", kinesisParameters)
    def getRetryPolicy
        : ZIO[Any, AwsError, zio.aws.scheduler.model.RetryPolicy.ReadOnly] =
      AwsError.unwrapOptionField("retryPolicy", retryPolicy)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getSageMakerPipelineParameters: ZIO[
      Any,
      AwsError,
      zio.aws.scheduler.model.SageMakerPipelineParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sageMakerPipelineParameters",
      sageMakerPipelineParameters
    )
    def getSqsParameters
        : ZIO[Any, AwsError, zio.aws.scheduler.model.SqsParameters.ReadOnly] =
      AwsError.unwrapOptionField("sqsParameters", sqsParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.Target
  ) extends zio.aws.scheduler.model.Target.ReadOnly {
    override val arn: TargetArn =
      zio.aws.scheduler.model.primitives.TargetArn(impl.arn())
    override val deadLetterConfig
        : Optional[zio.aws.scheduler.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.scheduler.model.DeadLetterConfig.wrap(value))
    override val ecsParameters
        : Optional[zio.aws.scheduler.model.EcsParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecsParameters())
        .map(value => zio.aws.scheduler.model.EcsParameters.wrap(value))
    override val eventBridgeParameters
        : Optional[zio.aws.scheduler.model.EventBridgeParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBridgeParameters())
        .map(value => zio.aws.scheduler.model.EventBridgeParameters.wrap(value))
    override val input: Optional[TargetInput] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.scheduler.model.primitives.TargetInput(value))
    override val kinesisParameters
        : Optional[zio.aws.scheduler.model.KinesisParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisParameters())
        .map(value => zio.aws.scheduler.model.KinesisParameters.wrap(value))
    override val retryPolicy
        : Optional[zio.aws.scheduler.model.RetryPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryPolicy())
        .map(value => zio.aws.scheduler.model.RetryPolicy.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.scheduler.model.primitives.RoleArn(impl.roleArn())
    override val sageMakerPipelineParameters: Optional[
      zio.aws.scheduler.model.SageMakerPipelineParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sageMakerPipelineParameters())
      .map(value =>
        zio.aws.scheduler.model.SageMakerPipelineParameters.wrap(value)
      )
    override val sqsParameters
        : Optional[zio.aws.scheduler.model.SqsParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqsParameters())
        .map(value => zio.aws.scheduler.model.SqsParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.Target
  ): zio.aws.scheduler.model.Target.ReadOnly = new Wrapper(impl)
}
