package zio.aws.scheduler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.scheduler.model.primitives.{TagKey, TagResourceArn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: TagResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.UntagResourceRequest
      .builder()
      .resourceArn(TagResourceArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.UntagResourceRequest.ReadOnly =
    zio.aws.scheduler.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.UntagResourceRequest =
      zio.aws.scheduler.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: TagResourceArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, TagResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.UntagResourceRequest
  ) extends zio.aws.scheduler.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: TagResourceArn =
      zio.aws.scheduler.model.primitives.TagResourceArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.scheduler.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.UntagResourceRequest
  ): zio.aws.scheduler.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
