package zio.aws.scheduler.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.scheduler.model.primitives.{
  EndDate,
  ScheduleGroupName,
  StartDate,
  ScheduleExpression,
  Description,
  ScheduleExpressionTimezone,
  ClientToken,
  KmsKeyArn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateScheduleRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    endDate: Optional[EndDate] = Optional.Absent,
    flexibleTimeWindow: zio.aws.scheduler.model.FlexibleTimeWindow,
    groupName: Optional[ScheduleGroupName] = Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    name: Name,
    scheduleExpression: ScheduleExpression,
    scheduleExpressionTimezone: Optional[ScheduleExpressionTimezone] =
      Optional.Absent,
    startDate: Optional[StartDate] = Optional.Absent,
    state: Optional[zio.aws.scheduler.model.ScheduleState] = Optional.Absent,
    target: zio.aws.scheduler.model.Target
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest = {
    import UpdateScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(endDate.map(value => EndDate.unwrap(value): Instant))(
        _.endDate
      )
      .flexibleTimeWindow(flexibleTimeWindow.buildAwsValue())
      .optionallyWith(
        groupName.map(value =>
          ScheduleGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .name(Name.unwrap(name): java.lang.String)
      .scheduleExpression(
        ScheduleExpression.unwrap(scheduleExpression): java.lang.String
      )
      .optionallyWith(
        scheduleExpressionTimezone.map(value =>
          ScheduleExpressionTimezone.unwrap(value): java.lang.String
        )
      )(_.scheduleExpressionTimezone)
      .optionallyWith(startDate.map(value => StartDate.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .target(target.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.scheduler.model.UpdateScheduleRequest.ReadOnly =
    zio.aws.scheduler.model.UpdateScheduleRequest.wrap(buildAwsValue())
}
object UpdateScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.scheduler.model.UpdateScheduleRequest =
      zio.aws.scheduler.model.UpdateScheduleRequest(
        clientToken.map(value => value),
        description.map(value => value),
        endDate.map(value => value),
        flexibleTimeWindow.asEditable,
        groupName.map(value => value),
        kmsKeyArn.map(value => value),
        name,
        scheduleExpression,
        scheduleExpressionTimezone.map(value => value),
        startDate.map(value => value),
        state.map(value => value),
        target.asEditable
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def endDate: Optional[EndDate]
    def flexibleTimeWindow: zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly
    def groupName: Optional[ScheduleGroupName]
    def kmsKeyArn: Optional[KmsKeyArn]
    def name: Name
    def scheduleExpression: ScheduleExpression
    def scheduleExpressionTimezone: Optional[ScheduleExpressionTimezone]
    def startDate: Optional[StartDate]
    def state: Optional[zio.aws.scheduler.model.ScheduleState]
    def target: zio.aws.scheduler.model.Target.ReadOnly
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndDate: ZIO[Any, AwsError, EndDate] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getFlexibleTimeWindow: ZIO[
      Any,
      Nothing,
      zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly
    ] = ZIO.succeed(flexibleTimeWindow)
    def getGroupName: ZIO[Any, AwsError, ScheduleGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getScheduleExpression: ZIO[Any, Nothing, ScheduleExpression] =
      ZIO.succeed(scheduleExpression)
    def getScheduleExpressionTimezone
        : ZIO[Any, AwsError, ScheduleExpressionTimezone] =
      AwsError.unwrapOptionField(
        "scheduleExpressionTimezone",
        scheduleExpressionTimezone
      )
    def getStartDate: ZIO[Any, AwsError, StartDate] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getState: ZIO[Any, AwsError, zio.aws.scheduler.model.ScheduleState] =
      AwsError.unwrapOptionField("state", state)
    def getTarget: ZIO[Any, Nothing, zio.aws.scheduler.model.Target.ReadOnly] =
      ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest
  ) extends zio.aws.scheduler.model.UpdateScheduleRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.scheduler.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.scheduler.model.primitives.Description(value))
    override val endDate: Optional[EndDate] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.scheduler.model.primitives.EndDate(value))
    override val flexibleTimeWindow
        : zio.aws.scheduler.model.FlexibleTimeWindow.ReadOnly =
      zio.aws.scheduler.model.FlexibleTimeWindow.wrap(impl.flexibleTimeWindow())
    override val groupName: Optional[ScheduleGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.scheduler.model.primitives.ScheduleGroupName(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.scheduler.model.primitives.KmsKeyArn(value))
    override val name: Name =
      zio.aws.scheduler.model.primitives.Name(impl.name())
    override val scheduleExpression: ScheduleExpression =
      zio.aws.scheduler.model.primitives
        .ScheduleExpression(impl.scheduleExpression())
    override val scheduleExpressionTimezone
        : Optional[ScheduleExpressionTimezone] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleExpressionTimezone())
      .map(value =>
        zio.aws.scheduler.model.primitives.ScheduleExpressionTimezone(value)
      )
    override val startDate: Optional[StartDate] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.scheduler.model.primitives.StartDate(value))
    override val state: Optional[zio.aws.scheduler.model.ScheduleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.scheduler.model.ScheduleState.wrap(value))
    override val target: zio.aws.scheduler.model.Target.ReadOnly =
      zio.aws.scheduler.model.Target.wrap(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.scheduler.model.UpdateScheduleRequest
  ): zio.aws.scheduler.model.UpdateScheduleRequest.ReadOnly = new Wrapper(impl)
}
