package zio.aws.scheduler
import zio.prelude.Subtype
import zio.aws.scheduler.model.primitives.{
  TagValue,
  TagKey,
  Subnet,
  SecurityGroup
}
import java.time.Instant
import zio.aws.scheduler.model.primitives.NextToken.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object CapacityProvider extends Subtype[String]
    type CapacityProvider =
      zio.aws.scheduler.model.primitives.CapacityProvider.Type
    object CapacityProviderStrategyItemBase extends Subtype[Int]
    type CapacityProviderStrategyItemBase =
      zio.aws.scheduler.model.primitives.CapacityProviderStrategyItemBase.Type
    object CapacityProviderStrategyItemWeight extends Subtype[Int]
    type CapacityProviderStrategyItemWeight =
      zio.aws.scheduler.model.primitives.CapacityProviderStrategyItemWeight.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.scheduler.model.primitives.ClientToken.Type
    object CreationDate extends Subtype[Instant]
    type CreationDate = zio.aws.scheduler.model.primitives.CreationDate.Type
    object DeadLetterConfigArnString extends Subtype[String]
    type DeadLetterConfigArnString =
      zio.aws.scheduler.model.primitives.DeadLetterConfigArnString.Type
    object Description extends Subtype[String]
    type Description = zio.aws.scheduler.model.primitives.Description.Type
    object DetailType extends Subtype[String]
    type DetailType = zio.aws.scheduler.model.primitives.DetailType.Type
    object EnableECSManagedTags extends Subtype[Boolean]
    type EnableECSManagedTags =
      zio.aws.scheduler.model.primitives.EnableECSManagedTags.Type
    object EnableExecuteCommand extends Subtype[Boolean]
    type EnableExecuteCommand =
      zio.aws.scheduler.model.primitives.EnableExecuteCommand.Type
    object EndDate extends Subtype[Instant]
    type EndDate = zio.aws.scheduler.model.primitives.EndDate.Type
    object Group extends Subtype[String]
    type Group = zio.aws.scheduler.model.primitives.Group.Type
    object KmsKeyArn extends Subtype[String]
    type KmsKeyArn = zio.aws.scheduler.model.primitives.KmsKeyArn.Type
    object LastModificationDate extends Subtype[Instant]
    type LastModificationDate =
      zio.aws.scheduler.model.primitives.LastModificationDate.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.scheduler.model.primitives.MaxResults.Type
    object MaximumEventAgeInSeconds extends Subtype[Int]
    type MaximumEventAgeInSeconds =
      zio.aws.scheduler.model.primitives.MaximumEventAgeInSeconds.Type
    object MaximumRetryAttempts extends Subtype[Int]
    type MaximumRetryAttempts =
      zio.aws.scheduler.model.primitives.MaximumRetryAttempts.Type
    object MaximumWindowInMinutes extends Subtype[Int]
    type MaximumWindowInMinutes =
      zio.aws.scheduler.model.primitives.MaximumWindowInMinutes.Type
    object MessageGroupId extends Subtype[String]
    type MessageGroupId = zio.aws.scheduler.model.primitives.MessageGroupId.Type
    object Name extends Subtype[String]
    type Name = zio.aws.scheduler.model.primitives.Name.Type
    object NamePrefix extends Subtype[String]
    type NamePrefix = zio.aws.scheduler.model.primitives.NamePrefix.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.scheduler.model.primitives.NextToken.Type
    object PlacementConstraintExpression extends Subtype[String]
    type PlacementConstraintExpression =
      zio.aws.scheduler.model.primitives.PlacementConstraintExpression.Type
    object PlacementStrategyField extends Subtype[String]
    type PlacementStrategyField =
      zio.aws.scheduler.model.primitives.PlacementStrategyField.Type
    object PlatformVersion extends Subtype[String]
    type PlatformVersion =
      zio.aws.scheduler.model.primitives.PlatformVersion.Type
    object ReferenceId extends Subtype[String]
    type ReferenceId = zio.aws.scheduler.model.primitives.ReferenceId.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.scheduler.model.primitives.RoleArn.Type
    object SageMakerPipelineParameterName extends Subtype[String]
    type SageMakerPipelineParameterName =
      zio.aws.scheduler.model.primitives.SageMakerPipelineParameterName.Type
    object SageMakerPipelineParameterValue extends Subtype[String]
    type SageMakerPipelineParameterValue =
      zio.aws.scheduler.model.primitives.SageMakerPipelineParameterValue.Type
    object ScheduleArn extends Subtype[String]
    type ScheduleArn = zio.aws.scheduler.model.primitives.ScheduleArn.Type
    object ScheduleExpression extends Subtype[String]
    type ScheduleExpression =
      zio.aws.scheduler.model.primitives.ScheduleExpression.Type
    object ScheduleExpressionTimezone extends Subtype[String]
    type ScheduleExpressionTimezone =
      zio.aws.scheduler.model.primitives.ScheduleExpressionTimezone.Type
    object ScheduleGroupArn extends Subtype[String]
    type ScheduleGroupArn =
      zio.aws.scheduler.model.primitives.ScheduleGroupArn.Type
    object ScheduleGroupName extends Subtype[String]
    type ScheduleGroupName =
      zio.aws.scheduler.model.primitives.ScheduleGroupName.Type
    object ScheduleGroupNamePrefix extends Subtype[String]
    type ScheduleGroupNamePrefix =
      zio.aws.scheduler.model.primitives.ScheduleGroupNamePrefix.Type
    object SecurityGroup extends Subtype[String]
    type SecurityGroup = zio.aws.scheduler.model.primitives.SecurityGroup.Type
    object Source extends Subtype[String]
    type Source = zio.aws.scheduler.model.primitives.Source.Type
    object StartDate extends Subtype[Instant]
    type StartDate = zio.aws.scheduler.model.primitives.StartDate.Type
    object Subnet extends Subtype[String]
    type Subnet = zio.aws.scheduler.model.primitives.Subnet.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.scheduler.model.primitives.TagKey.Type
    object TagResourceArn extends Subtype[String]
    type TagResourceArn = zio.aws.scheduler.model.primitives.TagResourceArn.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.scheduler.model.primitives.TagValue.Type
    object TargetArn extends Subtype[String]
    type TargetArn = zio.aws.scheduler.model.primitives.TargetArn.Type
    object TargetInput extends Subtype[String]
    type TargetInput = zio.aws.scheduler.model.primitives.TargetInput.Type
    object TargetPartitionKey extends Subtype[String]
    type TargetPartitionKey =
      zio.aws.scheduler.model.primitives.TargetPartitionKey.Type
    object TaskCount extends Subtype[Int]
    type TaskCount = zio.aws.scheduler.model.primitives.TaskCount.Type
    object TaskDefinitionArn extends Subtype[String]
    type TaskDefinitionArn =
      zio.aws.scheduler.model.primitives.TaskDefinitionArn.Type
  }
  type CapacityProviderStrategy =
    List[zio.aws.scheduler.model.CapacityProviderStrategyItem]
  type PlacementConstraints = List[zio.aws.scheduler.model.PlacementConstraint]
  type PlacementStrategies = List[zio.aws.scheduler.model.PlacementStrategy]
  type SageMakerPipelineParameterList =
    List[zio.aws.scheduler.model.SageMakerPipelineParameter]
  type ScheduleGroupList = List[zio.aws.scheduler.model.ScheduleGroupSummary]
  type ScheduleList = List[zio.aws.scheduler.model.ScheduleSummary]
  type SecurityGroups = List[SecurityGroup]
  type Subnets = List[Subnet]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.scheduler.model.Tag]
  type TagMap = Map[TagKey, TagValue]
  type Tags = List[Map[TagKey, TagValue]]
}
